// --------------------------------------------------------------------
// CTableFaqa.hxx
// Whatis:  faqa table access class
// Faqaors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableFaqa_hxx
#define CTableFaqa_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	faqa_faqq;		// Reference to question          
	dword_t	faqa_idnt;		// Identifier for this answer     
	char	faqa_auth[101];	// Author name of this answer     
	time_t	faqa_time;		// Time when written              
	char	faqa_head[201];	// Header text (title if you like)
	dword_t	faqa_answ;		// The answer text reference      
}   data_faqa_t,
*   data_faqa_tp,
**  data_faqa_th;
typedef list <data_faqa_t>               data_faqa_tl;
typedef data_faqa_tl::iterator           data_faqa_tli;
typedef data_faqa_tl::const_iterator     data_faqa_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableFaqa class
// --------------------------------------------------------------------
class   CTableFaqa : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableFaqa ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableFaqa              ( const CTableFaqa & );
    CTableFaqa & operator = ( const CTableFaqa & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableFaqa();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_faqa_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_faqa_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_faqa_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_faqa_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_faqa_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableFaqa_hxx
// --------------------------------------------------------------------
// EOF: CTableFaqa.hxx
// --------------------------------------------------------------------
