// --------------------------------------------------------------------
// CTableFaqq.hxx
// Whatis:  faqq table access class
// Faqqors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableFaqq_hxx
#define CTableFaqq_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	faqq_idnt;		// Record identifier, used to reference a faqq
	char	faqq_auth[101]; // Author name of this FAQ                    
	time_t	faqq_time;		// Time when written                          
	char	faqq_head[201];	// Header text (title if you like)            
	dword_t	faqq_ques;		// The question text reference                
}   data_faqq_t,
*   data_faqq_tp,
**  data_faqq_th;
typedef list <data_faqq_t>               data_faqq_tl;
typedef data_faqq_tl::iterator           data_faqq_tli;
typedef data_faqq_tl::const_iterator     data_faqq_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableFaqq class
// --------------------------------------------------------------------
class   CTableFaqq : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableFaqq ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableFaqq              ( const CTableFaqq & );
    CTableFaqq & operator = ( const CTableFaqq & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableFaqq();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_faqq_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_faqq_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_faqq_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_faqq_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_faqq_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableFaqq_hxx
// --------------------------------------------------------------------
// EOF: CTableFaqq.hxx
// --------------------------------------------------------------------
