// --------------------------------------------------------------------
// CTableFile.hxx
// Whatis:  file table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CTableFile_hxx
#define CTableFile_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	file_idnt;			// Record identifier, used to reference a file
	dword_t	file_auth;			// Owner of this file
	dword_t	file_type;			// Type of this file
	char	file_typ1[9];		// Primary type
	char	file_ctgr[65];		// Category
	char	file_typ2[17];		// Secondary type
	char	file_name[101];		// Real name of the file
	char	file_suff[33];		// Suffix
	dword_t	file_vers;			// Version number
	char	file_csum[101];		// Checksum of the file, used to find identical files
	time_t	file_ctim;			// Creation time
	time_t	file_mtim;			// Modification time
	time_t	file_atim;			// Arrival time
	time_t	file_ltim;			// Last access time
	dword_t	file_size;			// Size of the file
	dword_t	file_psiz;			// Packed size of the file
	dword_t	file_lcnt;			// Load count
	dword_t	file_flag;			// Flags for the file
	char	file_data[65];		// Absolute path to the gzipped file image
	dword_t	file_user;			// Indentifier of the owner of this file
	dword_t	file_rate;			// Rating of the file 0 .. 100
	dword_t	file_rat0;			// Number of bad klicks for this file      
	dword_t	file_rat1;			// Number of average klicks for this file  
	dword_t	file_rat2;			// Number of good klicks for this file
	dword_t	file_dlct;			// Download count
	dword_t	file_plct;			// Played count
}   data_file_t,
*   data_file_tp,
**  data_file_th;
typedef list <data_file_t>               data_file_tl;
typedef data_file_tl::iterator           data_file_tli;
typedef data_file_tl::const_iterator     data_file_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableFile class
// --------------------------------------------------------------------
class   CTableFile : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableFile ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableFile              ( const CTableFile & );
    CTableFile & operator = ( const CTableFile & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableFile();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_file_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_file_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_file_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_file_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_file_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableFile_hxx
// --------------------------------------------------------------------
// EOF: CTableFile.hxx
// --------------------------------------------------------------------
