// --------------------------------------------------------------------
// CTableHitc.hxx
// Whatis:  hitc table access class
// Hitcors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableHitc_hxx
#define CTableHitc_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	hitc_idnt[65];		// The id of the hit counter
	dword_t	hitc_hits;			// Number of hits ever
}   data_hitc_t,
*   data_hitc_tp,
**  data_hitc_th;
typedef list <data_hitc_t>               data_hitc_tl;
typedef data_hitc_tl::iterator           data_hitc_tli;
typedef data_hitc_tl::const_iterator     data_hitc_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableHitc class
// --------------------------------------------------------------------
class   CTableHitc : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableHitc ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableHitc              ( const CTableHitc & );
    CTableHitc & operator = ( const CTableHitc & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableHitc();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_hitc_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_hitc_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_hitc_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_hitc_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_hitc_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableHitc_hxx
// --------------------------------------------------------------------
// EOF: CTableHitc.hxx
// --------------------------------------------------------------------
