// --------------------------------------------------------------------
// CTableMenu.hxx
// Whatis:  menu table access class
// Menuors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableMenu_hxx
#define CTableMenu_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	menu_name[33];	// Name of this entry
	dword_t	menu_ordr;		// Used to order the menu's inside one selection
	char	menu_pnam[33];	// Parent entry name of this entry
	dword_t	menu_pord;		// Parent entry order of this entry
	char	menu_text[101];	// Text appearing as the link (use absolute url for images)
	char	menu_onst[33];	// CSS class for on style of the menu text
	char	menu_ofst[33];	// CSS class for off style of the menu text
	char	menu_link[251];	// URL
	char	menu_titl[251];	// Title
	char	menu_ttst[33];	// CSS class for title line
	char	menu_brfn[251];	// Briefing
	char	menu_brst[33];	// CSS class for briefing
}   data_menu_t,
*   data_menu_tp,
**  data_menu_th;
typedef list <data_menu_t>               data_menu_tl;
typedef data_menu_tl::iterator           data_menu_tli;
typedef data_menu_tl::const_iterator     data_menu_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableMenu class
// --------------------------------------------------------------------
class   CTableMenu : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableMenu ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableMenu              ( const CTableMenu & );
    CTableMenu & operator = ( const CTableMenu & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableMenu();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_menu_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_menu_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_menu_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_menu_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_menu_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableMenu_hxx
// --------------------------------------------------------------------
// EOF: CTableMenu.hxx
// --------------------------------------------------------------------
