// --------------------------------------------------------------------
// CTablePackFile.hxx
// Whatis:  packfile table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTablePackFile_hxx
#define CTablePackFile_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	packfile_file;			// File relation
	dword_t	packfile_pack;			// Pack relation
}   data_packfile_t,
*   data_packfile_tp,
**  data_packfile_th;
typedef list <data_packfile_t>               data_packfile_tl;
typedef data_packfile_tl::iterator           data_packfile_tli;
typedef data_packfile_tl::const_iterator     data_packfile_tlci;

// --------------------------------------------------------------------
// Declaration of the CTablePackFile class
// --------------------------------------------------------------------
class   CTablePackFile : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTablePackFile ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTablePackFile              ( const CTablePackFile & );
    CTablePackFile & operator = ( const CTablePackFile & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTablePackFile();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_packfile_tl   	Select  (  	CMySqlConnect_t &,
	                               	const char *,
                                	bool = false );

    data_packfile_tl	Select  (  	CMySqlConnect_t & aDb,
    	                       		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_packfile_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_packfile_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_packfile_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTablePackFile_hxx
// --------------------------------------------------------------------
// EOF: CTablePackFile.hxx
// --------------------------------------------------------------------
