// --------------------------------------------------------------------
// CTablePref.hxx
// Whatis:  pref table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CTablePref_hxx
#define CTablePref_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
    char    pref_name       [33];
    char    pref_valu       [201];
}   data_pref_t,
*   data_pref_tp,
**  data_pref_th;
typedef list <data_pref_t>               data_pref_tl;
typedef data_pref_tl::iterator           data_pref_tli;
typedef data_pref_tl::const_iterator     data_pref_tlci;

// --------------------------------------------------------------------
// Declaration of the CTablePref class
// --------------------------------------------------------------------
class   CTablePref : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTablePref ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTablePref              ( const CTablePref & );
    CTablePref & operator = ( const CTablePref & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTablePref();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_pref_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_pref_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_pref_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_pref_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_pref_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTablePref_hxx
// --------------------------------------------------------------------
// EOF: CTablePref.hxx
// --------------------------------------------------------------------
