// --------------------------------------------------------------------
// CTableRule.hxx
// Whatis:  rule table access class
// Ruleors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableRule_hxx
#define CTableRule_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	rule_type;			// Record identifier, used to reference a type
	char	rule_name[33];		// Real name of the rule
	char	rule_rule[201];		// Instructions
}   data_rule_t,
*   data_rule_tp,
**  data_rule_th;
typedef list <data_rule_t>               data_rule_tl;
typedef data_rule_tl::iterator           data_rule_tli;
typedef data_rule_tl::const_iterator     data_rule_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableRule class
// --------------------------------------------------------------------
class   CTableRule : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableRule ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableRule              ( const CTableRule & );
    CTableRule & operator = ( const CTableRule & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableRule();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_rule_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_rule_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_rule_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_rule_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_rule_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableRule_hxx
// --------------------------------------------------------------------
// EOF: CTableRule.hxx
// --------------------------------------------------------------------
