// --------------------------------------------------------------------
// CTableSpam.hxx
// Whatis:  spam table access class
// Spamors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableSpam_hxx
#define CTableSpam_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	spam_idnt[201];		// The address+command of the spam
	dword_t	spam_time;			// Latest time spammed
}   data_spam_t,
*   data_spam_tp,
**  data_spam_th;
typedef list <data_spam_t>               data_spam_tl;
typedef data_spam_tl::iterator           data_spam_tli;
typedef data_spam_tl::const_iterator     data_spam_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableSpam class
// --------------------------------------------------------------------
class   CTableSpam : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableSpam ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableSpam              ( const CTableSpam & );
    CTableSpam & operator = ( const CTableSpam & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableSpam();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_spam_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_spam_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_spam_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_spam_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_spam_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableSpam_hxx
// --------------------------------------------------------------------
// EOF: CTableSpam.hxx
// --------------------------------------------------------------------
