// --------------------------------------------------------------------
// CTableSrvr.hxx
// Whatis:  srvr table access class
// Srvrors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableSrvr_hxx
#define CTableSrvr_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	srvr_addr	[65];
	dword_t	srvr_port	;
	dword_t	srvr_quep	;
	char	srvr_type	[9];
	char	srvr_name	[201];
	char	srvr_gmap	[65];
	char	srvr_gttl	[201];
	char	srvr_gtyp	[33];
	dword_t	srvr_pcur	;
	dword_t	srvr_pmax	;
	time_t	srvr_time	;
}   data_srvr_t,
*   data_srvr_tp,
**  data_srvr_th;
typedef list <data_srvr_t>               data_srvr_tl;
typedef data_srvr_tl::iterator           data_srvr_tli;
typedef data_srvr_tl::const_iterator     data_srvr_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableSrvr class
// --------------------------------------------------------------------
class   CTableSrvr : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableSrvr ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableSrvr              ( const CTableSrvr & );
    CTableSrvr & operator = ( const CTableSrvr & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableSrvr();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_srvr_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_srvr_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_srvr_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_srvr_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_srvr_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableSrvr_hxx
// --------------------------------------------------------------------
// EOF: CTableSrvr.hxx
// --------------------------------------------------------------------
