// --------------------------------------------------------------------
// CTableType.hxx
// Whatis:  type table access class
// Typeors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableType_hxx
#define CTableType_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	type_idnt;			// Record identifier, used to reference a type
	char	type_ctgr[65];		// Category
	char	type_name[101];		// Real name of the type
	dword_t	type_apri;			// Author priority (used in detecting authors)
}   data_type_t,
*   data_type_tp,
**  data_type_th;
typedef list <data_type_t>               data_type_tl;
typedef data_type_tl::iterator           data_type_tli;
typedef data_type_tl::const_iterator     data_type_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableType class
// --------------------------------------------------------------------
class   CTableType : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableType ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableType              ( const CTableType & );
    CTableType & operator = ( const CTableType & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableType();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_type_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_type_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_type_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_type_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_type_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableType_hxx
// --------------------------------------------------------------------
// EOF: CTableType.hxx
// --------------------------------------------------------------------
