// --------------------------------------------------------------------
// CTableXref.hxx
// Whatis:  xref table access class
// Xrefors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableXref_hxx
#define CTableXref_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	xref_file;			// Refers the file record this is connected to
	dword_t	xref_expo;			// 0 -> Import, 1 -> Export
	char	xref_name[41];		// Name of the import/export item
	dword_t	xref_refs;			// Number of references
}   data_xref_t,
*   data_xref_tp,
**  data_xref_th;
typedef list <data_xref_t>               data_xref_tl;
typedef data_xref_tl::iterator           data_xref_tli;
typedef data_xref_tl::const_iterator     data_xref_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableXref class
// --------------------------------------------------------------------
class   CTableXref : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableXref ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableXref              ( const CTableXref & );
    CTableXref & operator = ( const CTableXref & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableXref();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_xref_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_xref_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_xref_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_xref_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_xref_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableXref_hxx
// --------------------------------------------------------------------
// EOF: CTableXref.hxx
// --------------------------------------------------------------------
