# ################################################################
# UTCMS_auth.sql
# Creates auth table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: file(file_auth)
# refers  : user(auth_user)
#
# ################################################################
# Field descriptions
# ################################################################
# auth_idnt		Record identifier, used to reference a auth
# auth_user		Who owns this author
# auth_name		Name of this author
# auth_flag		Common flags - see CMySqlData.hxx
# auth_rate		Readily calculated rate for the author - range 0 ... 10000
# auth_rat0		Number of bad klicks for this author
# auth_rat1		Number of average klicks for this author
# auth_rat2		Number of good klicks for this author
# auth_dlct		Download count
# auth_plct		Players count

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS auth;

# ################################################################
# Create the auth table and it's indexes
# ################################################################
CREATE TABLE auth (
	auth_idnt	INTEGER			NOT NULL	DEFAULT 0,
	auth_user	INTEGER			NOT NULL	DEFAULT 0,
	auth_name	CHAR(100)		NOT NULL,
	auth_flag	INTEGER			NOT NULL	DEFAULT 0,
	auth_rate	INTEGER			NOT NULL	DEFAULT 0,
	auth_rat0	INTEGER			NOT NULL	DEFAULT 0,
	auth_rat1	INTEGER			NOT NULL	DEFAULT 0,
	auth_rat2	INTEGER			NOT NULL	DEFAULT 0,
	auth_dlct	INTEGER			NOT NULL	DEFAULT 0,
	auth_plct	INTEGER			NOT NULL	DEFAULT 0,

	PRIMARY KEY ( auth_idnt )
);

CREATE INDEX		auth_user_ix		ON auth ( auth_user );
CREATE INDEX		auth_name_ix		ON auth ( auth_name );
CREATE INDEX		auth_rate_ix		ON auth ( auth_rate );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON auth TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Some default authors
# ################################################################
INSERT INTO auth ( 	auth_idnt, auth_user, auth_name, auth_flag ) VALUES
(	1,	1,	"Epic Games",	0 ),
(	2,	2,	"UTCMS System",	0 );

# ################################################################
# EOF: UTCMS_auth.sql
# ################################################################
