# ################################################################
# UTCMS_faqa.sql
# Creates faqa table - contains FAQ Answers
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: faqq
# refers  :	faqt
#
# ################################################################
# Field descriptions
# ################################################################
# faqa_faqq		Reference to question
# faqa_idnt		Identifier for this answer
# faqa_auth		Author name of this answer
# faqa_time		Time when written
# faqa_head		Header text (title if you like)
# faqa_answ		The answer text reference

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS faqa;

# ################################################################
# Create the faqa table and it's indexes
# ################################################################
CREATE TABLE faqa (
	faqa_faqq	INTEGER			NOT NULL	DEFAULT 0,
	faqa_idnt	INTEGER			NOT NULL	DEFAULT 0,
	faqa_auth	CHAR(100)		NOT NULL,
	faqa_time	DATETIME		NOT NULL,
	faqa_head	CHAR(200)		NOT NULL,
	faqa_answ	INTEGER			NOT NULL	DEFAULT 0,
	PRIMARY KEY ( faqa_faqq, faqa_idnt )
);

CREATE INDEX		faqa_auth_ix		ON faqa ( faqa_auth );
CREATE INDEX		faqa_time_ix		ON faqa ( faqa_time );
CREATE INDEX		faqa_head_ix		ON faqa ( faqa_head );
CREATE UNIQUE INDEX	faqa_answ_ix		ON faqa ( faqa_answ );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON faqa TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_faqa.sql
# ################################################################
