# ################################################################
# UTCMS_faqt.sql
# Creates faqt table - contains text objects
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: faqq faqa
# refers  :
#
# ################################################################
# Field descriptions
# ################################################################
# faqt_idnt		Record identifier, used to reference a faqt
# faqt_auth		Author name of this FAQ text
# faqt_time		Time when written
# faqt_text		The text

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS faqt;

# ################################################################
# Create the faqt table and it's indexes
# ################################################################
CREATE TABLE faqt (
	faqt_idnt	INTEGER			NOT NULL	DEFAULT 0,
	faqt_auth	CHAR(100)		NOT NULL,
	faqt_time	DATETIME		NOT NULL,
	faqt_text	TEXT			NOT NULL,
	PRIMARY KEY ( faqt_idnt )
);

CREATE INDEX		faqt_auth_ix		ON faqt ( faqt_auth );
CREATE INDEX		faqt_time_ix		ON faqt ( faqt_time );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON faqt TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_faqt.sql
# ################################################################
