# ################################################################
# UTCMS_fsrv.sql
# Creates fsrv table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ################################################################
# Field descriptions
# ################################################################

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS fsrv;

# ################################################################
# Create the fsrv table and it's indexes
# ################################################################
CREATE TABLE fsrv (
	fsrv_file	INTEGER			NOT NULL	DEFAULT 0,
	fsrv_addr	CHAR(64)		NOT NULL,
	fsrv_quep	INTEGER			NOT NULL	DEFAULT 0,
	fsrv_pcur	INTEGER			NOT NULL	DEFAULT 0,
	fsrv_pmax	INTEGER			NOT NULL	DEFAULT 0,
	fsrv_time	DATETIME		NOT NULL,
	PRIMARY KEY ( fsrv_file, fsrv_addr, fsrv_quep )
);

CREATE INDEX		fsrv_addr_ix		ON fsrv ( fsrv_addr );
CREATE INDEX		fsrv_time_ix		ON fsrv ( fsrv_time );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON fsrv TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_fsrv.sql
# ################################################################
