# ################################################################
# UTCMS_pack.sql
# Creates pack table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: packfile(packfile_pack)
# refers  : user(pack_user), text(pack_text), pict(pack_pict)
#
# ################################################################
# Field descriptions
# ################################################################
# pack_idnt		Record identifier, used to reference a pack
# pack_name		Name of this package
# pack_file		Suggested filename for retrieving this package
# pack_user		Owner of this package
# pack_text		Attached text
# pack_pict		Attached picture
# pack_atim		Arrival time
# pack_mtim		Modification time
# pack_ltim		Access time
# pack_flag		Common flags - see CMySqlData.hxx

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS pack;

# ################################################################
# Create the pack table and it's indexes
# ################################################################
CREATE TABLE pack (
	pack_idnt	INTEGER			NOT NULL	DEFAULT 0,
	pack_name	CHAR(100)		NOT NULL,
	pack_file	CHAR(100)		NOT NULL,
	pack_user	INTEGER			NOT NULL	DEFAULT 0,
	pack_text	INTEGER			NOT NULL	DEFAULT 0,
	pack_pict	INTEGER			NOT NULL	DEFAULT 0,
	pack_atim	DATETIME		NOT NULL,
	pack_mtim	DATETIME		NOT NULL,
	pack_ltim	DATETIME		NOT NULL,
	pack_flag	INTEGER			NOT NULL	DEFAULT 0,

	PRIMARY KEY ( pack_idnt )
);

CREATE INDEX			pack_name_ix		ON pack ( pack_name );
CREATE INDEX			pack_file_ix		ON pack ( pack_file );
CREATE INDEX			pack_user_ix		ON pack ( pack_user );
CREATE INDEX			pack_atim_ix		ON pack ( pack_atim );
CREATE INDEX			pack_mtim_ix		ON pack ( pack_mtim );
CREATE INDEX			pack_ltim_ix		ON pack ( pack_ltim );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON pack TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_pack.sql
# ################################################################
