# ################################################################
# UTCMS_user.sql
# Creates user table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: auth(auth_user)	grupuser(grupuser_user) mail(mail_user)
#			site(site_user)
# refers  : text(user_text) pict(user_pict)
#
# ################################################################
# Field descriptions
# ################################################################
# user_idnt		Record identifier, used to reference a user
# user_name		Real name of this user
# user_logn		Login name of this user
# user_pass		Password for the user
# user_text		Some text about this user
# user_pict		Picture of this user
# user_atim		Arrival time
# user_ltim		Last visit time
# user_flag		Common flags - see CMySqlData.hxx
# user_cook		Cookie string
# user_whtn		What's new time
# user_colo		Color scheme

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS user;

# ################################################################
# Create the user table and it's indexes
# ################################################################
CREATE TABLE user (
	user_idnt	INTEGER			NOT NULL	DEFAULT 0,
	user_name	CHAR(100)		NOT NULL,
	user_logn	CHAR(100)		NOT NULL,
	user_pass	CHAR(100)		NOT NULL,
	user_text	INTEGER			NOT NULL	DEFAULT 0,
	user_pict	INTEGER			NOT NULL	DEFAULT 0,
	user_atim	DATETIME		NOT NULL,
	user_ltim	DATETIME		NOT NULL,
	user_flag	INTEGER			NOT NULL	DEFAULT 0,
	user_cook	CHAR(100)		NOT NULL,
	user_whtm	DATETIME		NOT NULL,
	user_colo	CHAR(250)		NOT NULL,

	PRIMARY KEY ( user_idnt )
);

CREATE INDEX		user_idnt_ix		ON user ( user_idnt );
CREATE INDEX		user_name_ix		ON user ( user_name );
CREATE UNIQUE INDEX	user_logn_ix		ON user ( user_logn );
CREATE INDEX		user_atim_ix		ON user ( user_atim );
CREATE INDEX		user_ltim_ix		ON user ( user_ltim );
CREATE INDEX		user_cook_ix		ON user ( user_cook );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON user TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_user.sql
# ################################################################

