# ################################################################
# UTCMS_wurl.sql
# Creates wurl table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from:
# refers  :
#
# ################################################################
# Field descriptions
# ################################################################
# wurl_idnt			Record identifier, used to reference a wurl
# wurl_type			Type of this URL
# wurl_titl			Title
# wurl_desc			Short description
# wurl_link			The actual link
# wurl_rate			Access rating, 0=inaccessible, 10 = OK
# wurl_ltim			Last access time

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS wurl;

# ################################################################
# Create the wurl table and it's indexes
# ################################################################
CREATE TABLE wurl (
	wurl_idnt	INTEGER			NOT NULL	DEFAULT 0,
	wurl_type	CHAR(32)		NOT NULL,
	wurl_titl	CHAR(100)		NOT NULL,
	wurl_desc	CHAR(250)		NOT NULL,
	wurl_link	CHAR(200)		NOT NULL,
	wurl_rate	INTEGER			NOT NULL	DEFAULT 0,
	wurl_ltim	DATETIME		NOT NULL,

	PRIMARY KEY ( wurl_idnt )
);

CREATE INDEX		wurl_type_ix		ON wurl ( wurl_type );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON wurl TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_wurl.sql
# ################################################################

