# ################################################################
# restore.sql
# Restores the UTCMS tables from a backup
# ################################################################

# ################################################################
# Drop the database, should drop all tables on it
# ################################################################
DROP    DATABASE IF EXISTS  UTCMS;
CREATE  DATABASE            UTCMS;
USE UTCMS;

# ################################################################
# Restore the backup
# ################################################################
RESTORE TABLE auth FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE arep FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE file FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE dcac FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE pcac FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE pack FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE packfile FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE pref FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE menu FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE quot FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE rule FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE sess FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE slog FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE srvr FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE fsrv FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE type FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE user FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE xref FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE wurl FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE hitc FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE faqt FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE faqq FROM '/mnt/disk1/mysql/backup/UTCMS';
RESTORE TABLE faqa FROM '/mnt/disk1/mysql/backup/UTCMS';


# ################################################################
# Build the indexes
# ################################################################
REPAIR TABLE auth EXTENDED;
REPAIR TABLE arep EXTENDED;
REPAIR TABLE file EXTENDED;
REPAIR TABLE dcac EXTENDED;
REPAIR TABLE pcac EXTENDED;
REPAIR TABLE pack EXTENDED;
REPAIR TABLE packfile EXTENDED;
REPAIR TABLE pref EXTENDED;
REPAIR TABLE menu EXTENDED;
REPAIR TABLE quot EXTENDED;
REPAIR TABLE rule EXTENDED;
REPAIR TABLE sess EXTENDED;
REPAIR TABLE slog EXTENDED;
REPAIR TABLE srvr EXTENDED;
REPAIR TABLE fsrv EXTENDED;
REPAIR TABLE stat EXTENDED;
REPAIR TABLE type EXTENDED;
REPAIR TABLE user EXTENDED;
REPAIR TABLE xref EXTENDED;
REPAIR TABLE wurl EXTENDED;
REPAIR TABLE hitc EXTENDED;
REPAIR TABLE faqt EXTENDED;
REPAIR TABLE faqq EXTENDED;
REPAIR TABLE faqa EXTENDED;


# ################################################################
# Grants
# ################################################################
GRANT ALL ON auth TO quest@localhost;
GRANT ALL ON arep TO quest@localhost;
GRANT ALL ON file TO quest@localhost;
GRANT ALL ON dcac TO quest@localhost;
GRANT ALL ON pcac TO quest@localhost;
GRANT ALL ON pack TO quest@localhost;
GRANT ALL ON packfile TO quest@localhost;
GRANT ALL ON pref TO quest@localhost;
GRANT ALL ON menu TO quest@localhost;
GRANT ALL ON quot TO quest@localhost;
GRANT ALL ON rule TO quest@localhost;
GRANT ALL ON sess TO quest@localhost;
GRANT ALL ON slog TO quest@localhost;
GRANT ALL ON srvr TO quest@localhost;
GRANT ALL ON fsrv TO quest@localhost;
GRANT ALL ON type TO quest@localhost;
GRANT ALL ON user TO quest@localhost;
GRANT ALL ON xref TO quest@localhost;
GRANT ALL ON wurl TO quest@localhost;
GRANT ALL ON hitc TO quest@localhost;
GRANT ALL ON faqt TO quest@localhost;
GRANT ALL ON faqq TO quest@localhost;
GRANT ALL ON faqa TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: restore.sql
# ################################################################
