// --------------------------------------------------------------------
// CMySqlConnect.cxx
// Whatis:  Connection to MySQL database
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CMySqlConnect.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CMySqlConnect::CMySqlConnect (  const char * aUser,
                                const char * aPass,
                                const char * aDbas,
                                const char * aHost ) {
    itsConnect = false;
    ::mysql_init( &itsMysql );

	// If we don't have a host specified, we just might get one from the environment
	if	( aHost == NULL )	aHost = ::getenv( "MYSQL_HOST_ADDRESS" );

    if  ( ! ::mysql_real_connect( &itsMysql, aHost, aUser, aPass, aDbas, 0, NULL, 0 ) ) {
        throw CError( ::mysql_error( &itsMysql ) );
    }
    itsConnect = true;
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CMySqlConnect::~CMySqlConnect ( ) {
    if  ( itsConnect )  ::mysql_close( &itsMysql );
    itsConnect = false;
}

// --------------------------------------------------------------------
// EOF: CMySqlConnect.cxx
// --------------------------------------------------------------------
