// --------------------------------------------------------------------
// CTableArep.cxx
// Whatis:  arep table access
// Arepors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableArep.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,  101, "arep_find",       false },    // 0
    {   0,  data_struct_type_ascz,   65, "arep_fnam",       false },    // 1
    {   0,  data_struct_type_ascz,   65, "arep_nnam",       false },    // 2
    {   0,  data_struct_type_ascz,   65, "arep_lnam",       false },    // 3
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableArep::CTableArep    ( ) : CMySqlData( __rules, sizeof( data_arep_t ) ) {
    if  ( ! __initialized ) {
        data_arep_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, arep_find, arep_find );
	    __rules[i++].offset = DATA_OFFSET( model, arep_find, arep_fnam );
	    __rules[i++].offset = DATA_OFFSET( model, arep_find, arep_nnam );
	    __rules[i++].offset = DATA_OFFSET( model, arep_find, arep_lnam );
	    __initialized = true;
    }
}
CTableArep::~CTableArep   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableArep::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "arep", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_arep_tl   CTableArep::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_arep_tl   list;
    data_arep_th   result;

    result = (data_arep_th)CMySqlData::MakeSelect( aDb, "arep", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableArep::Insert (   CMySqlConnect_t &   aDb,
                                           data_arep_tp   aR ) {
    data_arep_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "arep", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableArep::Update (   CMySqlConnect_t &   aDb,
                                           data_arep_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_arep_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "arep_find='" << q.Quote( aR->arep_find ) << "'";
    CMySqlData::MakeUpdate( aDb, "arep", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableArep::Delete (   CMySqlConnect_t &   aDb,
                                                data_arep_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "arep_find='" << q.Quote( aR->arep_find ) << "'";
        CMySqlData::MakeDelete( aDb, "arep", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "arep" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableArep::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "arep", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableArep::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableArep.cxx
// --------------------------------------------------------------------
