// --------------------------------------------------------------------
// CTableAuth.cxx
// Whatis:  auth table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableAuth.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "auth_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "auth_user",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "auth_name",       false },    // 2
    {   0,  data_struct_type_dword,   4, "auth_flag",       false },    // 3
    {   0,  data_struct_type_dword,   4, "auth_rate",       false },    // 4
    {   0,  data_struct_type_dword,   4, "auth_rat0",       false },    // 5
    {   0,  data_struct_type_dword,   4, "auth_rat1",       false },    // 6
    {   0,  data_struct_type_dword,   4, "auth_rat2",       false },    // 7
    {   0,  data_struct_type_dword,   4, "auth_dlct",       false },    // 8
    {   0,  data_struct_type_dword,   4, "auth_plct",       false },    // 9
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableAuth::CTableAuth    ( ) : CMySqlData( __rules, sizeof( data_auth_t ) ) {
    if  ( ! __initialized ) {
        data_auth_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_user );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_name );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_flag );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_rate );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_rat0 );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_rat1 );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_rat2 );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_dlct );
	    __rules[i++].offset = DATA_OFFSET( model, auth_idnt, auth_plct );
	    __initialized = true;
    }
}
CTableAuth::~CTableAuth   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableAuth::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "auth", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_auth_tl   CTableAuth::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_auth_tl   list;
    data_auth_th   result;

    result = (data_auth_th)CMySqlData::MakeSelect( aDb, "auth", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableAuth::Insert (   CMySqlConnect_t &   aDb,
                                           data_auth_tp   aR ) {
    data_auth_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "auth", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableAuth::Update (   CMySqlConnect_t &   aDb,
                                           data_auth_tp   aR ) {
    CMySqlWhere         where;
    data_auth_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "auth_idnt=" << aR->auth_idnt;
    CMySqlData::MakeUpdate( aDb, "auth", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableAuth::Delete (   CMySqlConnect_t &   aDb,
                                                data_auth_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "auth_idnt=" << aR->auth_idnt;
        CMySqlData::MakeDelete( aDb, "auth", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "auth" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableAuth::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "auth", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableAuth::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableAuth::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "auth", "auth_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableAuth.cxx
// --------------------------------------------------------------------
