// --------------------------------------------------------------------
// CTableCach.cxx
// Whatis:  cach table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableCach.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,  251, "cach_file",       false },    // 0
    {   0,  data_struct_type_dword,   4, "cach_size",       false },    // 1
    {   0,  data_struct_type_time,    4, "cach_ltim",       false },    // 2
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableCach::CTableCach    ( ) : CMySqlData( __rules, sizeof( data_cach_t ) ) {
    if  ( ! __initialized ) {
        data_cach_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, cach_file, cach_file );
	    __rules[i++].offset = DATA_OFFSET( model, cach_file, cach_size );
	    __rules[i++].offset = DATA_OFFSET( model, cach_file, cach_ltim );
	    __initialized = true;
    }
}
CTableCach::~CTableCach   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableCach::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "cach", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_cach_tl   CTableCach::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_cach_tl   list;
    data_cach_th   result;

    result = (data_cach_th)CMySqlData::MakeSelect( aDb, "cach", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableCach::Insert (   CMySqlConnect_t &   aDb,
                                           data_cach_tp   aR ) {
    data_cach_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "cach", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableCach::Update (   CMySqlConnect_t &   aDb,
                                           data_cach_tp   aR ) {
    CMySqlWhere		where;
    CMySqlQuote		q;
    data_cach_tp	data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "cach_file='" << q.Quote( aR->cach_file ) << "'";
    CMySqlData::MakeUpdate( aDb, "cach", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableCach::Delete (   CMySqlConnect_t &   aDb,
                                           data_cach_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote	q;
	    where << "cach_file='" << q.Quote( aR->cach_file ) << "'";
        CMySqlData::MakeDelete( aDb, "cach", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "cach" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableCach::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "cach", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableCach::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableCach.cxx
// --------------------------------------------------------------------
