// --------------------------------------------------------------------
// CTableDeny.cxx
// Whatis:  deny table access
// Denyors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableDeny.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,  101, "deny_name",       false },    // 0
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableDeny::CTableDeny    ( ) : CMySqlData( __rules, sizeof( data_deny_t ) ) {
    if  ( ! __initialized ) {
        data_deny_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, deny_name, deny_name );
	    __initialized = true;
    }
}
CTableDeny::~CTableDeny   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableDeny::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "deny", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_deny_tl   CTableDeny::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_deny_tl   list;
    data_deny_th   result;

    result = (data_deny_th)CMySqlData::MakeSelect( aDb, "deny", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableDeny::Insert (   CMySqlConnect_t &   aDb,
                                           data_deny_tp   aR ) {
    data_deny_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "deny", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableDeny::Update (   CMySqlConnect_t &   aDb,
                                           data_deny_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_deny_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "deny_name=" << q.Quote(aR->deny_name);
    CMySqlData::MakeUpdate( aDb, "deny", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableDeny::Delete (   CMySqlConnect_t &   aDb,
                                                data_deny_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "deny_name=" << q.Quote(aR->deny_name);
        CMySqlData::MakeDelete( aDb, "deny", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "deny" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableDeny::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "deny", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableDeny::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableDeny.cxx
// --------------------------------------------------------------------
