// --------------------------------------------------------------------
// CTableFaqa.cxx
// Whatis:  faqa table access
// Faqaors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableFaqa.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "faqa_faqq",       false },    // 0
    {   0,  data_struct_type_dword,   4, "faqa_idnt",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "faqa_auth",       false },    // 2
    {   0,  data_struct_type_time,    4, "faqa_time",       false },    // 3
    {   0,  data_struct_type_ascz,  201, "faqa_head",       false },    // 4
    {   0,  data_struct_type_dword,   4, "faqa_answ",       false },    // 5
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableFaqa::CTableFaqa    ( ) : CMySqlData( __rules, sizeof( data_faqa_t ) ) {
    if  ( ! __initialized ) {
        data_faqa_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_faqq );
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_auth );
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_time );
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_head );
	    __rules[i++].offset = DATA_OFFSET( model, faqa_idnt, faqa_answ );
	    __initialized = true;
    }
}
CTableFaqa::~CTableFaqa   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableFaqa::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "faqa", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_faqa_tl   CTableFaqa::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_faqa_tl   list;
    data_faqa_th   result;

    result = (data_faqa_th)CMySqlData::MakeSelect( aDb, "faqa", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableFaqa::Insert (   CMySqlConnect_t &   aDb,
                                           data_faqa_tp   aR ) {
    data_faqa_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "faqa", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableFaqa::Update (   CMySqlConnect_t &   aDb,
                                           data_faqa_tp   aR ) {
    CMySqlWhere    where;
    data_faqa_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "faqa_idnt=" << aR->faqa_idnt << " AND faqa_faqq=" << aR->faqa_faqq;
    CMySqlData::MakeUpdate( aDb, "faqa", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFaqa::Delete (   CMySqlConnect_t &   aDb,
                                                data_faqa_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "faqa_idnt=" << aR->faqa_idnt << " AND faqa_faqq=" << aR->faqa_faqq;
        CMySqlData::MakeDelete( aDb, "faqa", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "faqa" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFaqa::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "faqa", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableFaqa::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableFaqa::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "faqa", "faqa_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableFaqa.cxx
// --------------------------------------------------------------------
