// --------------------------------------------------------------------
// CTableFaqq.cxx
// Whatis:  faqq table access
// Faqqors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableFaqq.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "faqq_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,  101, "faqq_auth",       false },    // 1
    {   0,  data_struct_type_time,    4, "faqq_time",       false },    // 2
    {   0,  data_struct_type_ascz,  201, "faqq_head",       false },    // 3
    {   0,  data_struct_type_dword,   4, "faqq_ques",       false },    // 4
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableFaqq::CTableFaqq    ( ) : CMySqlData( __rules, sizeof( data_faqq_t ) ) {
    if  ( ! __initialized ) {
        data_faqq_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, faqq_idnt, faqq_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, faqq_idnt, faqq_auth );
	    __rules[i++].offset = DATA_OFFSET( model, faqq_idnt, faqq_time );
	    __rules[i++].offset = DATA_OFFSET( model, faqq_idnt, faqq_head );
	    __rules[i++].offset = DATA_OFFSET( model, faqq_idnt, faqq_ques );
	    __initialized = true;
    }
}
CTableFaqq::~CTableFaqq   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableFaqq::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "faqq", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_faqq_tl   CTableFaqq::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_faqq_tl   list;
    data_faqq_th   result;

    result = (data_faqq_th)CMySqlData::MakeSelect( aDb, "faqq", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableFaqq::Insert (   CMySqlConnect_t &   aDb,
                                           data_faqq_tp   aR ) {
    data_faqq_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "faqq", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableFaqq::Update (   CMySqlConnect_t &   aDb,
                                           data_faqq_tp   aR ) {
    CMySqlWhere         where;
    data_faqq_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "faqq_idnt=" << aR->faqq_idnt;
    CMySqlData::MakeUpdate( aDb, "faqq", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFaqq::Delete (   CMySqlConnect_t &   aDb,
                                                data_faqq_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "faqq_idnt=" << aR->faqq_idnt;
        CMySqlData::MakeDelete( aDb, "faqq", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "faqq" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFaqq::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "faqq", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableFaqq::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableFaqq::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "faqq", "faqq_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableFaqq.cxx
// --------------------------------------------------------------------
