// --------------------------------------------------------------------
// CTableHitc.cxx
// Whatis:  hitc table access
// Hitcors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableHitc.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,   65, "hitc_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "hitc_hits",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableHitc::CTableHitc    ( ) : CMySqlData( __rules, sizeof( data_hitc_t ) ) {
    if  ( ! __initialized ) {
        data_hitc_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, hitc_idnt, hitc_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, hitc_idnt, hitc_hits );
	    __initialized = true;
    }
}

CTableHitc::~CTableHitc   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableHitc::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "hitc", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_hitc_tl   CTableHitc::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_hitc_tl   list;
    data_hitc_th   result;

    result = (data_hitc_th)CMySqlData::MakeSelect( aDb, "hitc", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableHitc::Insert (   CMySqlConnect_t &   aDb,
                                           data_hitc_tp   aR ) {
    data_hitc_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "hitc", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableHitc::Update (   CMySqlConnect_t &   aDb,
                                           data_hitc_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_hitc_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "hitc_idnt='" << q.Quote( aR->hitc_idnt ) << "'";
    CMySqlData::MakeUpdate( aDb, "hitc", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableHitc::Delete (   CMySqlConnect_t &   aDb,
                                                data_hitc_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "hitc_idnt='" << q.Quote( aR->hitc_idnt ) << "'";
        CMySqlData::MakeDelete( aDb, "hitc", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "hitc" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableHitc::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "hitc", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableHitc::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableHitc.cxx
// --------------------------------------------------------------------
