// --------------------------------------------------------------------
// CTableNews.cxx
// Whatis:  news table access
// Newsors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableNews.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "news_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "news_user",       false },    // 1
    {   0,  data_struct_type_time,    4, "news_time",       false },    // 2
    {   0,  data_struct_type_ascz,  251, "news_titl",       false },    // 3
    {   0,  data_struct_type_dword,   4, "news_file",       false },    // 4
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableNews::CTableNews    ( ) : CMySqlData( __rules, sizeof( data_news_t ) ) {
    if  ( ! __initialized ) {
        data_news_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, news_idnt, news_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, news_idnt, news_user );
	    __rules[i++].offset = DATA_OFFSET( model, news_idnt, news_time );
	    __rules[i++].offset = DATA_OFFSET( model, news_idnt, news_titl );
	    __rules[i++].offset = DATA_OFFSET( model, news_idnt, news_file );
	    __initialized = true;
    }
}

CTableNews::~CTableNews   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableNews::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "news", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_news_tl   CTableNews::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_news_tl   list;
    data_news_th   result;

    result = (data_news_th)CMySqlData::MakeSelect( aDb, "news", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableNews::Insert (   CMySqlConnect_t &   aDb,
                                           data_news_tp   aR ) {
    data_news_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "news", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableNews::Update (   CMySqlConnect_t &   aDb,
                                           data_news_tp   aR ) {
    CMySqlWhere         where;
    data_news_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "news_idnt="  << aR->news_idnt;
    CMySqlData::MakeUpdate( aDb, "news", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableNews::Delete (   CMySqlConnect_t &   aDb,
                                                data_news_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "news_idnt="  << aR->news_idnt;
        CMySqlData::MakeDelete( aDb, "news", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "news" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableNews::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "news", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableNews::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableNews::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "news", "news_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableNews.cxx
// --------------------------------------------------------------------
