// --------------------------------------------------------------------
// CTablePackFile.cxx
// Whatis:  packfile table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTablePackFile.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "packfile_file",       false },    // 0
    {   0,  data_struct_type_dword,   4, "packfile_pack",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTablePackFile::CTablePackFile    ( ) : CMySqlData( __rules, sizeof( data_packfile_t ) ) {
    if  ( ! __initialized ) {
        data_packfile_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, packfile_file, packfile_file );
	    __rules[i++].offset = DATA_OFFSET( model, packfile_file, packfile_pack );
	    __initialized = true;
    }
}
CTablePackFile::~CTablePackFile   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTablePackFile::Count (  	CMySqlConnect_t &   aDb,
                                    	const char *        aWhere,
                                    	bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "packfile", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_packfile_tl   CTablePackFile::Select (	CMySqlConnect_t &   aDb,
                                    		const char *        aWhere,
                                    		bool				aDist ) {
    data_packfile_tl   list;
    data_packfile_th   result;

    result = (data_packfile_th)CMySqlData::MakeSelect( aDb, "packfile", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTablePackFile::Insert (   CMySqlConnect_t &   aDb,
                                           data_packfile_tp   aR ) {
    data_packfile_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "packfile", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTablePackFile::Update (   CMySqlConnect_t &   aDb,
                                           data_packfile_tp   aR ) {
    CMySqlWhere         where;
    data_packfile_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "packfile_file=" << aR->packfile_file << " and ";
    where << "packfile_pack=" << aR->packfile_pack;
    CMySqlData::MakeUpdate( aDb, "packfile", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePackFile::Delete (   CMySqlConnect_t &   aDb,
                                                data_packfile_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "packfile_file=" << aR->packfile_file << " and ";
	    where << "packfile_pack=" << aR->packfile_pack;
        CMySqlData::MakeDelete( aDb, "packfile", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "packfile" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePackFile::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "packfile", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTablePackFile::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTablePackFile.cxx
// --------------------------------------------------------------------
