// --------------------------------------------------------------------
// CTableQuot.cxx
// Whatis:  quot table access
// Quotors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableQuot.hxx"

// --------------------------------------------------------------------
// local:       Quots used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __quots[] = {
    //  ofs quot                    size name               crypt
    {   0,  data_struct_type_dword,   4, "quot_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,  251, "quot_text",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableQuot::CTableQuot    ( ) : CMySqlData( __quots, sizeof( data_quot_t ) ) {
    if  ( ! __initialized ) {
        data_quot_t   model;
		int	i = 0;
	    __quots[i++].offset = DATA_OFFSET( model, quot_idnt, quot_idnt );
	    __quots[i++].offset = DATA_OFFSET( model, quot_idnt, quot_text );
	    __initialized = true;
    }
}
CTableQuot::~CTableQuot   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableQuot::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "quot", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_quot_tl   CTableQuot::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_quot_tl   list;
    data_quot_th   result;

    result = (data_quot_th)CMySqlData::MakeSelect( aDb, "quot", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableQuot::Insert (   CMySqlConnect_t &   aDb,
                                           data_quot_tp   aR ) {
    data_quot_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "quot", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableQuot::Update (   CMySqlConnect_t &   aDb,
                                           data_quot_tp   aR ) {
    CMySqlWhere         where;
    data_quot_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "quot_idnt="  << aR->quot_idnt;
    CMySqlData::MakeUpdate( aDb, "quot", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableQuot::Delete (   CMySqlConnect_t &   aDb,
                                                data_quot_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "quot_idnt="  << aR->quot_idnt;
        CMySqlData::MakeDelete( aDb, "quot", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "quot" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableQuot::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "quot", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableQuot::Layout  ( void ) const {
    return  __quots;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableQuot::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "quot", "quot_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableQuot.cxx
// --------------------------------------------------------------------
