// --------------------------------------------------------------------
// CTableSpam.cxx
// Whatis:  spam table access
// Spamors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableSpam.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,  201, "spam_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "spam_time",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableSpam::CTableSpam    ( ) : CMySqlData( __rules, sizeof( data_spam_t ) ) {
    if  ( ! __initialized ) {
        data_spam_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, spam_idnt, spam_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, spam_idnt, spam_time );
	    __initialized = true;
    }
}

CTableSpam::~CTableSpam   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableSpam::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "spam", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_spam_tl   CTableSpam::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_spam_tl   list;
    data_spam_th   result;

    result = (data_spam_th)CMySqlData::MakeSelect( aDb, "spam", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableSpam::Insert (   CMySqlConnect_t &   aDb,
                                           data_spam_tp   aR ) {
    data_spam_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "spam", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableSpam::Update (   CMySqlConnect_t &   aDb,
                                           data_spam_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_spam_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "spam_idnt='" << q.Quote( aR->spam_idnt ) << "'";
    CMySqlData::MakeUpdate( aDb, "spam", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSpam::Delete (   CMySqlConnect_t &   aDb,
                                                data_spam_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "spam_idnt='" << q.Quote( aR->spam_idnt ) << "'";
        CMySqlData::MakeDelete( aDb, "spam", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "spam" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSpam::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "spam", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableSpam::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableSpam.cxx
// --------------------------------------------------------------------
