// --------------------------------------------------------------------
// MySqlTableParse.cxx
// Whatis:  Parses table data
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// local:	Digit ?
// --------------------------------------------------------------------
static	bool	__isdigit		( char	aC ) {
	return	( aC >= '0' ) && ( aC <= '9' );
}

// --------------------------------------------------------------------
// local:	HTML output with pre/post filling
// --------------------------------------------------------------------
static	void	__HTML_output	(	const char *	aS,
									int				aF ) {
	if		( aF > 0 ) {
		if		( (int)::strlen( aS ) < aF ) {
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( "&nbsp;" );
				aF--;
			}
			::HTML_quote( aS );
		}
		else if	( (int)::strlen( aS ) > aF ) {
			char	bf[2];
			bf[1] = 0;
			while	( aF > 0 ) {
				bf[0] = *(aS++); aF--;
				::HTML_quote( bf );
			}
		}
		else {
			::HTML_quote( aS );
		}
	}

	else if	( aF < 0 ) {

		aF = -aF;
		if		( (int)::strlen( aS ) < aF ) {
			::HTML_quote( aS );
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( "&nbsp;" );
				aF--;
			}
		}
		else if	( (int)::strlen( aS ) > aF ) {
			char	bf[2];
			bf[1] = 0;
			while	( aF > 0 ) {
				bf[0] = *(aS++); aF--;
				::HTML_quote( bf );
			}
		}
		else {
			::HTML_quote( aS );
		}
	}

	else {
		::HTML_quote( aS );
	}
}

// --------------------------------------------------------------------
// local:	CGI output with pre/post filling
// --------------------------------------------------------------------
static	void	__CGI_output	(	const char *	aS,
									int				aF ) {
	if		( aF > 0 ) {
		if		( (int)::strlen( aS ) < aF ) {
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( "%%20" );
				aF--;
			}
			::CGI_quote( aS );
		}
		else if	( (int)::strlen( aS ) > aF ) {
			char	bf[2];
			bf[1] = 0;
			while	( aF > 0 ) {
				bf[0] = *(aS++); aF--;
				::CGI_quote( bf );
			}
		}
		else {
			::CGI_quote( aS );
		}
	}

	else if	( aF < 0 ) {

		aF = -aF;
		if		( (int)::strlen( aS ) < aF ) {
			::CGI_quote( aS );
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( "%%20" );
				aF--;
			}
		}
		else if	( (int)::strlen( aS ) > aF ) {
			char	bf[2];
			bf[1] = 0;
			while	( aF > 0 ) {
				bf[0] = *(aS++); aF--;
				::CGI_quote( bf );
			}
		}
		else {
			::CGI_quote( aS );
		}
	}

	else {
		::CGI_quote( aS );
	}
}

// --------------------------------------------------------------------
// local:	RAW output with pre/post filling
// --------------------------------------------------------------------
static	void	__RAW_output	(	const char *	aS,
									int				aF ) {
	if		( aF > 0 ) {
		if		( (int)::strlen( aS ) < aF ) {
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( " " );
				aF--;
			}
			::printf( "%s", aS );
		}
		else if	( (int)::strlen( aS ) > aF ) {
			while	( aF > 0 ) {
				::printf( "%c", *(aS++) );
				aF--;
			}
		}
		else {
			::printf( "%s", aS );
		}
	}

	else if	( aF < 0 ) {

		aF = -aF;
		if		( (int)::strlen( aS ) < aF ) {
			::printf( "%s", aS );
			aF = aF - ::strlen( aS );
			while	( aF > 0 ) {
				::printf( " " );
				aF--;
			}
		}
		else if	( (int)::strlen( aS ) > aF ) {
			while	( aF > 0 ) {
				::printf( "%c", *(aS++) );
				aF--;
			}
		}
		else {
			::printf( "%s", aS );
		}
	}

	else {
		::printf( "%s", aS );
	}
}

// --------------------------------------------------------------------
// local:	Parse data with HTML encoding
// --------------------------------------------------------------------
static	bool	__ParseHtmData	(	data_struct_descriptor_tp 	aT,
									const char *				aD,
									const char * 				aQ,
									int							aF ) {
    int     col;
    char	buf[40];

    for ( col = 0; aT[col].name; col++ ) {
        if  ( ! ::strcmp( aT[col].name, aQ ) ) {
            switch  ( aT[col].type ) {
                case    data_struct_type_time:
                __HTML_output( ::my_time_string( *DATA_LOCATION( aD, aT[col], time_t ) ), aF );
                break;

                case    data_struct_type_bool:
                __HTML_output( *DATA_LOCATION( aD, aT[col], bool ) ? "1" : "0", aF );
                break;

                case    data_struct_type_dword:
                ::sprintf( buf, "%d", *DATA_LOCATION( aD, aT[col], dword_t ) );
                __HTML_output( buf, aF );
                break;

                case    data_struct_type_ascz:
                __HTML_output( DATA_LOCATION( aD, aT[col], char ), aF );
                break;
            }

            return  true;
        }
    }
    return  false;
}

// --------------------------------------------------------------------
// local:	Parse data with CGI encoding
// --------------------------------------------------------------------
static	bool	__ParseCgiData	(	data_struct_descriptor_tp 	aT,
									const char *				aD,
									const char * 				aQ,
									int							aF ) {
    int     col;
    char	buf[40];

    for ( col = 0; aT[col].name; col++ ) {
        if  ( ! ::strcmp( aT[col].name, aQ ) ) {
            switch  ( aT[col].type ) {
                case    data_struct_type_time:
                __CGI_output( ::my_time_string( *DATA_LOCATION( aD, aT[col], time_t ) ), aF );
                break;

                case    data_struct_type_bool:
                __CGI_output( *DATA_LOCATION( aD, aT[col], bool ) ? "1" : "0", aF );
                break;

                case    data_struct_type_dword:
                ::sprintf( buf, "%d", *DATA_LOCATION( aD, aT[col], dword_t ) );
                __CGI_output( buf, aF );
                break;

                case    data_struct_type_ascz:
                __CGI_output( DATA_LOCATION( aD, aT[col], char ), aF );
                break;
            }

            return  true;
        }
    }
    return  false;
}

// --------------------------------------------------------------------
// local:	Parse data using size abbreviations
// --------------------------------------------------------------------
static	bool	__ParseSztData	(	data_struct_descriptor_tp 	aT,
									const char *				aD,
									const char * 				aQ,
									int							aF ) {
    int     	col;
    dword_t		val;
    struct tm * tms;
    char	buf[80];

    for ( col = 0; aT[col].name; col++ ) {
        if  ( ! ::strcmp( aT[col].name, aQ ) ) {
            switch  ( aT[col].type ) {

                case    data_struct_type_time:
				// Outputs data in form: YYYY-MM-DD HH:MM:SS
			    tms = ::gmtime( DATA_LOCATION( aD, aT[col], time_t ) );
			    *buf = 0;
			    ::sprintf( buf + strlen( buf), "%d-",   tms->tm_year + 1900 );
			    ::sprintf( buf + strlen( buf), "%s%d-", tms->tm_mon < 9 ? "0" : "", tms->tm_mon + 1 );
			    ::sprintf( buf + strlen( buf), "%s%d ", tms->tm_mday < 10 ? "0" : "", tms->tm_mday );
			    ::sprintf( buf + strlen( buf), "%s%d:", tms->tm_hour < 10 ? "0" : "", tms->tm_hour );
			    ::sprintf( buf + strlen( buf), "%s%d:", tms->tm_min  < 10 ? "0" : "", tms->tm_min );
			    ::sprintf( buf + strlen( buf), "%s%d",  tms->tm_sec  < 10 ? "0" : "", tms->tm_sec );
			    __RAW_output( buf, aF );
                break;

                case    data_struct_type_bool:
                __RAW_output( *DATA_LOCATION( aD, aT[col], bool ) ? "1" : "0", aF );
                break;

                case    data_struct_type_dword:
				val = *DATA_LOCATION( aD, aT[col], dword_t );
				if		( val < 1000 )			::sprintf( buf, "%d", val );
				else if	( val < 10000 )			::sprintf( buf, "%-4.3lfK", (double)val / 1000.0 );
				else if	( val < 100000 )		::sprintf( buf, "%-4.2lfK", (double)val / 1000.0 );
				else if	( val < 1000000 )		::sprintf( buf, "%-4.1lfK", (double)val / 1000.0 );
				else if	( val < 10000000 )		::sprintf( buf, "%-4.3lfM", (double)val / 1000000.0 );
				else if	( val < 100000000 )		::sprintf( buf, "%-4.2lfM", (double)val / 1000000.0 );
				else if	( val < 1000000000 )	::sprintf( buf, "%-4.1lfM", (double)val / 1000000.0 );
				else							::sprintf( buf, "%-4.3lfG", (double)val / 1000000000.0 );
			    __RAW_output( buf, aF );
                break;

                case    data_struct_type_ascz:
                __RAW_output( DATA_LOCATION( aD, aT[col], char ), aF );
                break;
            }

            return  true;
        }
    }
    return  false;
}

// --------------------------------------------------------------------
// local:	Parse data with no encoding
// --------------------------------------------------------------------
static	bool	__ParseRawData	(	data_struct_descriptor_tp 	aT,
									const char *				aD,
									const char * 				aQ,
									int							aF ) {
    int     col;
    char	buf[40];

    for ( col = 0; aT[col].name; col++ ) {
        if  ( ! ::strcmp( aT[col].name, aQ ) ) {
            switch  ( aT[col].type ) {
                case    data_struct_type_time:
                __RAW_output( ::my_time_string( *DATA_LOCATION( aD, aT[col], time_t ) ), aF );
                break;

                case    data_struct_type_bool:
                __RAW_output( *DATA_LOCATION( aD, aT[col], bool ) ? "1" : "0", aF );
                break;

                case    data_struct_type_dword:
                ::sprintf( buf, "%d", *DATA_LOCATION( aD, aT[col], dword_t ) );
			    __RAW_output( buf, aF );
                break;

                case    data_struct_type_ascz:
                __RAW_output( DATA_LOCATION( aD, aT[col], char ), aF );
                break;
            }

            return  true;
        }
    }
    return  false;
}

// --------------------------------------------------------------------
// local:	Parse difference data - applicable to dates only
// --------------------------------------------------------------------
static	bool	__ParseDifData	(	data_struct_descriptor_tp 	aT,
									const char *				aD,
									const char * 				aQ,
									int							aF ) {
    int     col;
    char	buf[40];
	dword_t	seconds;

    for ( col = 0; aT[col].name; col++ ) {
        if  ( ! ::strcmp( aT[col].name, aQ ) ) {
            switch  ( aT[col].type ) {
                case    data_struct_type_time:
				seconds = ::time( NULL ) - *DATA_LOCATION( aD, aT[col], time_t );
				if		( seconds < 60 ) {
					::sprintf( buf, "%d s.", seconds );
				}
				else if	( seconds < 60 * 60 ) {
					::sprintf( buf, "%d m.", seconds / 60 );
				}
				else if	( seconds < 60 * 60 * 24 ) {
					::sprintf( buf, "%d h.", seconds / (60 * 60) );
				}
				else {
					::sprintf( buf, "%d d.", seconds / (60 * 60 * 24) );
				}
                __RAW_output( buf, aF );
                break;

                case    data_struct_type_bool:
                __RAW_output( *DATA_LOCATION( aD, aT[col], bool ) ? "1" : "0", aF );
                break;

                case    data_struct_type_dword:
                ::sprintf( buf, "%d", *DATA_LOCATION( aD, aT[col], dword_t ) );
			    __RAW_output( buf, aF );
                break;

                case    data_struct_type_ascz:
                __RAW_output( DATA_LOCATION( aD, aT[col], char ), aF );
                break;
            }

            return  true;
        }
    }
    return  false;
}

// --------------------------------------------------------------------
// public:	The parser itself
// --------------------------------------------------------------------
extern	bool	MySqlTableParser (	data_struct_descriptor_tp 	aT,
									const char *				aTb,
									const char *				aD,
									const char * 				aQ ) {
	int		fill	= 0;

	if	( ::strncmp( aQ, aTb, ::strlen( aTb ) )	)	return false;
	if	( aQ[::strlen( aTb )] != '.' )				return false;
	aQ = aQ + ::strlen( aTb ) + 1;

	if	( ( (aQ[0] == '+') || (aQ[0] == '-') ) &&
		  ( __isdigit( aQ[1] ) ) &&
		  ( __isdigit( aQ[2] ) ) &&
		  ( aQ[3] == '.' ) ) {

		fill = 10 * (aQ[1] - '0');
		fill = fill + (aQ[2] - '0');
		if	( aQ[0] == '-' ) {
			fill = -fill;
		}
		aQ = aQ + 4;
	}

    if      ( ! ::strncmp( aQ, "cgi.", 4 ) )    return  __ParseCgiData( aT, aD, aQ + 4, fill );
    else if ( ! ::strncmp( aQ, "htm.", 4 ) )    return  __ParseHtmData( aT, aD, aQ + 4, fill );
    else if ( ! ::strncmp( aQ, "szt.", 4 ) )    return  __ParseSztData( aT, aD, aQ + 4, fill );
    else if ( ! ::strncmp( aQ, "dif.", 4 ) )    return  __ParseDifData( aT, aD, aQ + 4, fill );

    return  __ParseRawData( aT, aD, aQ, fill );
}

// --------------------------------------------------------------------
// EOF: MySqlTableParse.cxx
// --------------------------------------------------------------------
