// --------------------------------------------------------------------
// CDxt.hxx
// Whatis:  The DXT Texture library interface
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 11-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CDxt_hxx
#define     CDxt_hxx

#include	"Platform.hxx"


// --------------------------------------------------------------------
// Stuff needed by the libraries
// --------------------------------------------------------------------
enum {
    dSaveButton = 1,
    dCancelButton = 2,

    dDXT1 = 10,
    dTextureFormatFirst = dDXT1,

    dDXT1a = 11,  // DXT1 with one bit alpha
    dDXT3 = 12,   // explicit alpha
    dDXT5 = 13,   // interpolated alpha

    d4444 = 14,   // a4 r4 g4 b4
    d1555 = 15,   // a1 r5 g5 b5
    d565 = 16,    // a0 r5 g6 b5
    d8888 = 17,   // a8 r8 g8 b8
    d888 = 18,    // a0 r8 g8 b8
    d555 = 19,    // a0 r5 g5 b5
    d8   = 20,   // paletted

    dV8U8 = 21,   // DuDv 
    dCxV8U8 = 22,   // normal map
    dA8 = 23,            // alpha only
    d4 = 24,            // 16 bit color


    dTextureFormatLast = d4,

    dSaveTextureFormatCombo = 600,


    // 3d viewing options
    d3DPreviewButton = 300, 
    d2DPreviewButton = 301, 
    dPreviewRefresh = 302, 


    dViewDXT1 = 200,
    dViewDXT2 = 201,
    dViewDXT3 = 202,
    dViewDXT5 = 203,
    dViewA4R4G4B4 = 204,
    dViewA1R5G5B5 = 205,
    dViewR5G6B5 = 206,
    dViewA8R8G8B8 = 207,


    dGenerateMipMaps = 30,
    dMIPMapSourceFirst = dGenerateMipMaps,
    //dSpecifyMipMaps = 31,
    dUseExistingMipMaps = 31,
    dNoMipMaps = 32,
    dMIPMapSourceLast = dNoMipMaps,

    dSpecifiedMipMapsCombo = 39,

    dSpecifiedMipMapsAll = 1100,
    dSpecifiedMipMaps1 = 1101,
    dSpecifiedMipMaps2 = 1102,
    dSpecifiedMipMaps3 = 1103,
    dSpecifiedMipMaps4 = 1104,
    dSpecifiedMipMaps5 = 1105,
    dSpecifiedMipMaps6 = 1106,
    dSpecifiedMipMaps7 = 1107,
    dSpecifiedMipMaps8 = 1108,
    dSpecifiedMipMaps9 = 1109,


    dMIPFilterPoint = 133,    
    dMIPFilterFirst = dMIPFilterPoint,
    dMIPFilterBox = 134,      
    dMIPFilterTriangle = 135, 
    dMIPFilterQuadratic = 136,
    dMIPFilterCubic = 137,    

    dMIPFilterCatrom = 138,   
    dMIPFilterMitchell = 139, 

    dMIPFilterGaussian = 140, 
    dMIPFilterSinc = 141,     
    dMIPFilterBessel = 142,   

    dMIPFilterHanning = 143,  
    dMIPFilterHamming = 144,  
    dMIPFilterBlackman = 145, 
    dMIPFilterKaiser = 146,  

    dMIPFilterLast = dMIPFilterKaiser,


    dMIPFilterCombo = 601,


    dShowDifferences = 40,
    dShowFiltering = 41,
    dShowMipMapping = 42,
    dShowAnisotropic = 43,

    dChangeClearColorButton = 50,
    dDitherColor = 53,

    dLoadBackgroundImageButton = 54,
    dUseBackgroundImage = 55,

    dBinaryAlpha = 56,
    dAlphaBlending = 57,
    dFadeColor = 58,
    dFadeAlpha = 59,

    dFadeToColorButton = 60,
    dAlphaBorder = 61,
    dBorder = 62,
    dBorderColorButton = 63,
    dNormalizeMIPMaps = 64,

    dDitherEachMIPLevel = 66,
    dGreyScale = 67,
    dQuickCompress = 68,

    dbSharpenEachMIPLevel = 70,
    dSharpenEdgeRadius = 71,
    dSharpenLambda = 72,
    dSharpenMu = 73,
    dSharpenTheta = 74,
    dbSharpenUseTwoComponents = 75,
    dbSharpenNonMaximalSuppression = 76,
    dbSharpenFlavor2 = 77,
    dbSharpenSharpBlur = 78,

    dZoom = 79,




    dTextureType2D = 80,
    dTextureTypeFirst = dTextureType2D,
    dTextureTypeCube = 81,
    dTextureTypeImage = 82,
    dTextureTypeVolume = 83,  
    dTextureTypeLast = dTextureTypeVolume,

    dFadeAmount = 90,
    dFadeToAlpha = 91,
    dFadeToDelay = 92,

    dBinaryAlphaThreshold = 94,

    dFilterGamma = 100,
    dFilterBlur = 101,
    dFilterWidth = 102,
    dbOverrideFilterWidth = 103,



    dAskToLoadMIPMaps = 400,
    dShowAlphaWarning = 401,
    dShowPower2Warning = 402,
    dTextureFormatBasedOnAlpha = 403,
    dSystemMessage = 404,

    dAdvancedBlendingButton = 500,
    dUserSpecifiedFadingAmounts = 501,
    dSharpenSettingsButton = 502,
    dFilterSettingsButton = 503,
    dNormalMapGenerationSettingsButton = 504,


    ///////////  Normal Map

    dOK = 1001,
    dCancel = 1002,
    dScaleEditText = 1003,
    dProxyItem = 1005,
    dMinZEditText = 1008,

    dFilter4x = 1040,
    dFirstFilterRadio = dFilter4x,
    dFilter3x3 = 1041,
    dFilter5x5 = 1042,
    dFilterDuDv = 1043,
    dFilter7x7 = 1044,
    dFilter9x9 = 1045,
    dLastFilterRadio = dFilter9x9,

    dALPHA = 1009,
    dFirstCnvRadio = dALPHA,
    dAVERAGE_RGB = 1010,
    dBIASED_RGB = 1011,
    dRED = 1012,
    dGREEN = 1013,
    dBLUE = 1014,
    dMAX = 1015,
    dCOLORSPACE = 1016,
    dNORMALIZE = 1017,
    dLastCnvRadio = dNORMALIZE,

    d3DPreview = 1021,      
    dDecalTexture = 1022,
    dbUseDecalTexture = 1023,
    dbBrighten = 1024,
    dbAnimateLight = 1025,
    dStaticDecalName = 1026,


    dbWrap = 1030,
    dbMultipleLayers = 1031,
    db_16_16 = 1032,

    dAlphaNone = 1033,
    dFirstAlphaRadio = dAlphaNone,
    dAlphaHeight = 1034,
    dAlphaClear = 1035,
    dAlphaWhite = 1036,
    dLastAlphaRadio = dAlphaWhite,

    dbInvertY = 1037,
    db_12_12_8 = 1038,
    dbInvertX = 1039,

    dNormalMapConversion = 1050,
};

// --------------------------------------------------------------------
typedef enum RescaleOption
{
    RESCALE_NONE,               // no rescale
    RESCALE_NEAREST_POWER2,     // rescale to nearest power of two
    RESCALE_BIGGEST_POWER2,   // rescale to next bigger power of 2
    RESCALE_SMALLEST_POWER2,  // rescale to smaller power of 2 
    RESCALE_NEXT_SMALLEST_POWER2,  // rescale to next smaller power of 2
    RESCALE_PRESCALE,           // rescale to this size
    RESCALE_RELSCALE,           // relative rescale
    RESCALE_CLAMP,              //

} RescaleOption;


// --------------------------------------------------------------------
typedef	struct {
	BYTE	rgba[4];
}	rgba_t;

// --------------------------------------------------------------------
union tPixel {
	unsigned long	u;
	rgba_t			c;
};

// --------------------------------------------------------------------
typedef struct CompressionOptions {

    RescaleOption	bRescaleImage;
    float   		scaleX;
    float   		scaleY;
    bool            bMipMapsInImage;
    short           MipMapType;
    short           SpecifiedMipMaps;
    short           MIPFilterType;
    bool        	bBinaryAlpha;
    bool        	bNormalizeMIPMaps;
    bool        	bDuDvMap;
    bool        	bAlphaBorder;
    bool        	bBorder;
    tPixel      	BorderColor;
    bool        	bFadeColor;
    bool        	bFadeAlpha;
    tPixel      	FadeToColor;
    int         	FadeToAlpha;
    int         	FadeToDelay;
    int         	FadeAmount;
    int         	BinaryAlphaThreshold;
    bool        	bDitherColor;
    bool        	bDitherEachMIPLevel;
    bool        	bGreyScale;
    bool        	bQuickCompress;
    bool        	bForceDXT1FourColors;
	bool 			bSharpenEachMIPLevel;
    int 			SharpenEdgeRadius;
    float 			SharpenLambda;
    float 			SharpenMu;
    float 			SharpenTheta;
    bool 			bSharpenUseTwoComponents;
    bool 			bSharpenNonMaximalSuppression;
    bool 			bSharpenSharpBlur;
    bool 			bSharpenFlavor2;
    float 			FilterGamma;
    float 			FilterBlur;
    float 			FilterWidth;
    bool 			bOverrideFilterWidth;
	short 			TextureType;
	short 			TextureFormat;	    
    bool        	bSwapRGB;

} CompressionOptions;

// --------------------------------------------------------------------
typedef	void (*MIPFiltercallback)(int miplevel, int TotalMIPs);
typedef HRESULT (*MIPcallback)(void * data, int miplevel, DWORD size, int width, int height);

// --------------------------------------------------------------------
// extern:	nvDXTlib.lib, nvImageLib.lib, utility.lib, zoom.lib
// --------------------------------------------------------------------
extern	"C" {

extern	void	set_mip_filter_callback( MIPFiltercallback callback );

extern	HRESULT	nvDXTcompress(	unsigned char * 		raw_data,	// pointer to data (24 or 32 bit)
								unsigned long			w,			// width in texels
								unsigned long			h,			// height in texels
								DWORD					byte_pitch,
								const CompressionOptions *	options,
								DWORD					planes,		// 3 or 4
								MIPcallback				callback );	// callback for generated levels

extern	void	WriteDTXnFile	(DWORD count, void * buffer);
extern	void	ReadDTXnFile	(DWORD count, void * buffer);

}


#define	DXTERR_INPUT_POINTER_ZERO	-1
#define DXTERR_DEPTH_IS_NOT_3_OR_4	-2
#define DXTERR_NON_POWER_2			-3

// --------------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------------
class   CDxt {

	// ----------------------------------------------------------------
    public: 	// Constructor and destructor
	// ----------------------------------------------------------------
    CDxt	();
    ~CDxt 	();

	// ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
    CDxt				( const CDxt & );
    CDxt & operator =	( const CDxt & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	bool		IsPower2	( unsigned int ) const;






	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    CompressionOptions *		Options ( void );
    const CompressionOptions *	OptionsC( void ) const;
    void						Options	( const CompressionOptions * );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
    void		Free	( void );
    void		Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CompressionOptions		itsOptions;

};


#endif      // #ifndef CDxt_hxx
// --------------------------------------------------------------------
// EOF: CDxt.hxx
// --------------------------------------------------------------------
