// --------------------------------------------------------------------
// CFtpFile.hxx
// Whatis:  FTP Client class library
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFtpFile_hxx
#define CFtpFile_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
class CFtpFile {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFtpFile	();
	~CFtpFile	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFtpFile				( const CFtpFile & );
	CFtpFile & operator =	( const CFtpFile & );
    CFtpFile & operator =	( const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Name	( void ) const;
	size_t			Size	( void ) const;
	time_t			Time	( void ) const;
	bool			Dirf	( void ) const;
    char			Cmnd	( void ) const;

	void			Name	( const char * );
	void			Size	( size_t );
	void			Time	( time_t );
	void			Dirf	( bool );
    void			Cmnd	( char );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsName;
	size_t		itsSize;
	time_t		itsTime;
	bool		itsDirf;
    char		itsCmnd;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFtpFile>		CFtpFile_l;
typedef CFtpFile_l::iterator       	CFtpFile_li;
typedef CFtpFile_l::const_iterator	CFtpFile_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFtpFile.hxx
// --------------------------------------------------------------------
