// --------------------------------------------------------------------
// CFtpReply.hxx
// Whatis:  Reply for FTP client software
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CFtpReply_hxx
#define     CFtpReply_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------------
class   CFtpReply {

	// ----------------------------------------------------------------
    public: 	// Constructor and destructor
	// ----------------------------------------------------------------
    CFtpReply	();
    CFtpReply	( const char * );
    ~CFtpReply 	();

	// ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
    CFtpReply				( const CFtpReply & );
    CFtpReply & operator =	( const CFtpReply & );
    CFtpReply & operator =	( const char * );

	// ----------------------------------------------------------------
    public:		// Comparisons
	// ----------------------------------------------------------------
	bool operator ==		( const CFtpReply & ) const;
	bool operator ==		( int ) const;
	bool operator !=		( const CFtpReply & ) const;
	bool operator !=		( int ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	int				Code	( void ) const;
	const char *	Data	( void ) const;

	void			Code	( int );
	void			Data	( const char * );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
    void			Interpret	( const char * );
	void			Cleanup		( void );
	void			Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	int			itsCode;
	char *		itsData;
	
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFtpReply>		CFtpReply_l;
typedef CFtpReply_l::iterator      	CFtpReply_li;
typedef CFtpReply_l::const_iterator	CFtpReply_lci;

#endif      // #ifndef CFtpReply_hxx
// --------------------------------------------------------------------
// EOF: CFtpReply.hxx
// --------------------------------------------------------------------
