// --------------------------------------------------------------------
// CFtpSocket.hxx
// Whatis:  Socket class to be used by the FTP system
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef     CFtpSocket_hxx
#define     CFtpSocket_hxx

#include	"CCpuMutex.hxx"
#include	"CTcpSocket.hxx"
#include	"CFtpStream.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------
// States of this thread
// --------------------------------------------------------------
typedef	enum {
	ftp_socket_state_connect	= 0,	// Connecting
	ftp_socket_state_transfer	= 1,	// Transferring (idle)
	ftp_socket_state_hangup		= 2,	// Disconnected

	ftp_socket_state_abort		= 998,	// Aborting
	ftp_socket_state_error		= 999	// Error
}	ftp_socket_state_t;

// --------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------
class   CFtpSocket {

    // ----------------------------------------------------------
    public: 	// Constructor and destructor
    // ----------------------------------------------------------
    CFtpSocket  ( const char *, unsigned short, CFtpStream *, CFtpStream * );
	CFtpSocket	( CTcpSocket *, CFtpStream *, CFtpStream * );
    ~CFtpSocket ();

    // ----------------------------------------------------------
    private:	// Copy constructor and assignment operator - invalid
    // ----------------------------------------------------------
    CFtpSocket              ( const CFtpSocket & );
    CFtpSocket & operator = ( const CFtpSocket & );

    // ----------------------------------------------------------
	public:		// Running the thread
    // ----------------------------------------------------------
	void				Abort	( void );
	void				Run		( void );

    // ----------------------------------------------------------
	public:		// Accessing instance data
    // ----------------------------------------------------------
	const char *		Host	( void ) const;
	unsigned short		Port	( void ) const;
	ftp_socket_state_t	State	( void ) const;
	CError				Error	( void ) const;
	CTcpSocket *		Socket	( void );

    // ----------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------
	void				Connect	( void );
	void				Transfer( void );
	void				Cleanup	( void );
	void				Free	( void );

    // ----------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------
   	unsigned long		itsThreadId;
	char * 				itsHost;
	unsigned short		itsPort;
	ftp_socket_state_t	itsState;
	bool				itsRunning;
	CError				itsError;
	CTcpSocket *		itsListen;
	CTcpSocket *		itsSocket;
	CCpuMutex			itsMutex;
	CFtpStream *		itsInput;
	CFtpStream *		itsOutput;

};

#endif      // #ifndef CFtpSocket_hxx
// --------------------------------------------------------------
// EOF: CFtpSocket.hxx
// --------------------------------------------------------------
