// --------------------------------------------------------------------
// CFtpReply.cpp
// Whatis:  Reply for FTP client software
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#include	"CFtpReply.hxx"

// --------------------------------------------------------------------
CFtpReply::CFtpReply	() {
	CFtpReply::Cleanup();
}

// --------------------------------------------------------------------
CFtpReply::CFtpReply	( const char * aLine ) {
	CFtpReply::Cleanup();
	CFtpReply::Interpret( aLine );
}

// --------------------------------------------------------------------
CFtpReply::~CFtpReply 	() {
	CFtpReply::Free();
}

// --------------------------------------------------------------------
CFtpReply::CFtpReply ( const CFtpReply & aC ) {
	CFtpReply::Cleanup();
	CFtpReply::Code( aC.Code() );
	CFtpReply::Data( aC.Data() );
}

// --------------------------------------------------------------------
CFtpReply & CFtpReply::operator = ( const CFtpReply & aC ) {
	CFtpReply::Free();
	CFtpReply::Code( aC.Code() );
	CFtpReply::Data( aC.Data() );
    return *this;
}

// --------------------------------------------------------------------
CFtpReply & CFtpReply::operator = ( const char * aLine ) {
	CFtpReply::Free();
	CFtpReply::Interpret( aLine );
    return *this;
}

// --------------------------------------------------------------------
bool CFtpReply::operator == ( const CFtpReply & aC ) const {
	return	itsCode == aC.Code();
}

// --------------------------------------------------------------------
bool CFtpReply::operator == ( int aV ) const {
	return	itsCode == aV;
}

// --------------------------------------------------------------------
bool CFtpReply::operator != ( const CFtpReply & aC ) const {
	return	itsCode != aC.Code();
}

// --------------------------------------------------------------------
bool CFtpReply::operator != ( int aV ) const {
	return	itsCode != aV;
}

// --------------------------------------------------------------------
int		CFtpReply::Code ( void ) const {
	return	itsCode;
}

// --------------------------------------------------------------------
const char *	CFtpReply::Data ( void ) const {
	return	itsData ? itsData : "";
}

// --------------------------------------------------------------------
void	CFtpReply::Code	( int aV ) {
	itsCode = aV;
}

// --------------------------------------------------------------------
void	CFtpReply::Data	( const char * aV ) {
	if	( itsData )	delete [] itsData;
    itsData = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFtpReply::Interpret( const char * aL ) {
	CFtpReply::Free();

    // The three first characters must be digits
    if	( aL[0] < '0' )		return;
    if	( aL[1] < '0' )		return;
    if	( aL[2] < '0' )		return;
    if	( aL[0] > '9' )		return;
    if	( aL[1] > '9' )		return;
    if	( aL[2] > '9' )		return;

    // Next character must be a space
    if	( aL[3] != ' ' )	return;

    // Valid reply
	itsCode =	100 * ( aL[0] - '0' ) +
                 10 * ( aL[1] - '0' ) +
                      ( aL[2] - '0' );
	itsData = ::my_strfix( ::my_private_strdup( aL + 4 ) );
}

// --------------------------------------------------------------------
void	CFtpReply::Cleanup	( void ) {
	itsCode	= 0;
    itsData	= NULL;
}

// --------------------------------------------------------------------
void	CFtpReply::Free	( void ) {
	if	( itsData )	delete [] itsData;
	CFtpReply::Cleanup();
}

// --------------------------------------------------------------------
// EOF: CFtpReply.cpp
// --------------------------------------------------------------------
