// --------------------------------------------------------------------
// CFtpStreamCtl.cpp
// Whatis:  Control stream for the FTP system
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#include	"CFtpStreamCtl.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------
CFtpStreamCtl::CFtpStreamCtl	() {
	CFtpStreamCtl::Cleanup();
}

// --------------------------------------------------------------
CFtpStreamCtl::~CFtpStreamCtl 	() {
	CFtpStreamCtl::Free();
}

// --------------------------------------------------------------
int		CFtpStreamCtl::Read	( void ) {
	int		txch;
	itsMutex.Lock();
    if		( itsCommand == NULL ) {
		txch = FTP_STREAM_READ_IDLE;
    }
	else if	( itsCommand[itsCommandOffs] ) {
		txch = (int)((unsigned char)itsCommand[itsCommandOffs++]);
	}
	else {
		delete itsCommand;
        itsCommand = NULL;
		txch = FTP_STREAM_READ_IDLE;
	}

	itsMutex.Unlock();
	return	txch;
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Write	( char aChr ) {
	itsMutex.Lock();

	try	{
		if		( ( aChr == '\r' ) || ( aChr == '\n' ) )	CFtpStreamCtl::Interpret();
		else if	( aChr == 0 )								; // Skips zero chars
		else if	( itsReplyOffs > sizeof( itsReply ) - 2 )	throw CError( "Invalid reply" );
		else {
			itsReply[itsReplyOffs++] = aChr;
			itsReply[itsReplyOffs] = 0;
		}
		itsMutex.Unlock();
	}

	catch	( ... ) {
		itsMutex.Unlock();
		throw;
	}
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Flush		( void ) {
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Command		( const char * aCmnd ) {
    itsMutex.Lock();
	if	( itsCommand ) {
    	char *	original = itsCommand;
    	itsCommand = new char [ ::strlen( original ) + ::strlen( aCmnd ) + 3 - itsCommandOffs ];
		::strcpy( itsCommand, original + itsCommandOffs );
        delete [] original;
    }
    else {
    	itsCommand = new char [ ::strlen( aCmnd ) + 3 ];
		itsCommand[0] = 0;
    }
    ::strcat( itsCommand, aCmnd );
    ::strcat( itsCommand, "\r\n" );
    itsCommandOffs = 0;
    itsMutex.Unlock();
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Command		( const char * aC1, const char * aC2 ) {
	char *	buf = NULL;
    try {
		if	( aC2 ) {
	    	buf = new char [ ::strlen( aC1 ) + ::strlen( aC2 ) + 2 ];
    	    ::sprintf( buf, "%s %s", aC1, aC2 );
        	CFtpStreamCtl::Command( buf );
	        delete [] buf;
        }
        else {
        	CFtpStreamCtl::Command( aC1 );
        }
    }

    catch ( ... ) {
		if	( buf ) delete [] buf;
        throw;
    }
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Command		( const char * aC1, char aC2 ) {
	char *	buf = NULL;
    try {
    	buf = new char [ ::strlen( aC1 ) + 3 ];
        ::sprintf( buf, "%s %c", aC1, aC2 );
        CFtpStreamCtl::Command( buf );
        delete [] buf;
    }

    catch ( ... ) {
		if	( buf ) delete [] buf;
        throw;
    }
}

// --------------------------------------------------------------
CFtpReply	CFtpStreamCtl::Reply	( void ) {
	CFtpReply	reply;
    itsMutex.Lock();
	if	( itsReplyList.size() > 0 ) {
    	reply = itsReplyList.front();
        itsReplyList.pop_front();
    }
	itsMutex.Unlock();
    return	reply;
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Interpret( void ) {
	if	( itsReplyOffs > 2 ) {
		CFtpReply	myreply( itsReply );
		if	( myreply != 0 ) {
			itsReplyList.push_back( myreply );
		}
	}
	::memset( itsReply, 0, sizeof( itsReply ) );
	itsReplyOffs	= 0;
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Cleanup	( void ) {
	itsCommand 		= NULL;
	::memset( itsReply,   0, sizeof( itsReply ) );
	itsCommandOffs	= 0;
	itsReplyOffs	= 0;
    itsReplyList.clear();
}

// --------------------------------------------------------------
void	CFtpStreamCtl::Free	( void ) {
	if	( itsCommand )	delete [] itsCommand;
	CFtpStreamCtl::Cleanup();
}

// --------------------------------------------------------------
// EOF: CFtpStreamCtl.cpp
// --------------------------------------------------------------
