// --------------------------------------------------------------------
// CFurserDoc.h
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserDoc_h
#define CFurserDoc_h

#include	"CFurserController.h"
#include	"CFurserString.h"

// --------------------------------------------------------------------
class CFurserDoc {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserDoc		();
	~CFurserDoc		();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
	CFurserDoc				( const CFurserDoc & );
	CFurserDoc & operator =	( const CFurserDoc & );

	// ----------------------------------------------------------------
	public:		// Controller list management
	// ----------------------------------------------------------------
    CFurserString_l				ControllerNames	( void ) const;
	const CFurserController_l &	ControllerList	( void ) const;
    bool						HasController	( const char * ) const;
	CFurserController			GetController	( const char * ) const;
	void						SetController	( const char *, const CFurserController & );
	void						AddController	( const CFurserController & );
	void						DelController	( const CFurserController & );

	// ----------------------------------------------------------------
	public:		// Persistence
	// ----------------------------------------------------------------
	void		Save	( const char * ) const;
	void		Load	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void		Free	( void );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CFurserController_l		itsControllerList;

};

#endif
// --------------------------------------------------------------------
// EOF:	CFurserDoc.h
// --------------------------------------------------------------------
