// --------------------------------------------------------------------
// CFurserController.cpp
// Whatis:  Furser Controller class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserController.h"

// --------------------------------------------------------------------
CFurserController::CFurserController	() {
	CFurserController::Cleanup();
}

// --------------------------------------------------------------------
CFurserController::~CFurserController	() {
	CFurserController::Free();
}

// --------------------------------------------------------------------
CFurserController::CFurserController				( const CFurserController & aC ) {
	CFurserController::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserController & CFurserController::operator =	( const CFurserController & aC ) {
	CFurserController::Free();
	CFurserController::Ip( aC.Ip() );
	CFurserController::Port( aC.Port() );
	CFurserController::Pass( aC.Pass() );
	return *this;
}

// --------------------------------------------------------------------
bool CFurserController::operator == ( const CFurserController & aC ) const {
	return	*this == aC.Ip();
}

// --------------------------------------------------------------------
bool CFurserController::operator != ( const CFurserController & aC ) const {
	return	*this != aC.Ip();
}

// --------------------------------------------------------------------
bool CFurserController::operator == ( const char * aV ) const {
	return	::stricmp( CFurserController::Ip(), aV ? aV : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserController::operator != ( const char * aV ) const {
	return	::stricmp( CFurserController::Ip(), aV ? aV : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserController::Load	( const CWinIniFile & aW, dword_t aIx ) {
	char	secname	[64];
    ::sprintf( secname, "Controller_%d", aIx );
    CFurserController::Ip( aW.Value( secname, "Ip" ) );
    CFurserController::Port( (unsigned short)aW.IntValue( secname, "Port" ) );
    CFurserController::Pass( aW.Value( secname, "Pass" ) );
}

// --------------------------------------------------------------------
void	CFurserController::Save	( CWinIniFile & aW, dword_t aIx ) const {
	char			secname	[64];
    CWinIniSection	section;
    ::sprintf( secname, "Controller_%d", aIx );
    section.Name( secname );
	section.Insert( "Ip", CFurserController::Ip() );
	section.Insert( "Port", (int)CFurserController::Port() );
	section.Insert( "Pass", CFurserController::Pass() );
	aW.Insert( section );
}

// --------------------------------------------------------------------
const char *	CFurserController::Ip		( void ) const {
	return	itsIp ? itsIp : "";
}

// --------------------------------------------------------------------
unsigned short	CFurserController::Port	( void ) const {
	return itsPort;
}

// --------------------------------------------------------------------
const char *	CFurserController::Pass	( void ) const {
	return	itsPass ? itsPass : "";
}

// --------------------------------------------------------------------
void	CFurserController::Ip	( const char * aV ) {
	if	( itsIp )	delete [] itsIp;
	itsIp = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserController::Port	( unsigned short aV ) {
	itsPort = aV;
}

// --------------------------------------------------------------------
void	CFurserController::Pass	( const char * aV ) {
	if	( itsPass )	delete [] itsPass;
	itsPass = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserController::Free	( void ) {
	if	( itsIp )	delete [] itsIp;
	if	( itsPass )	delete [] itsPass;
	CFurserController::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserController::Cleanup	( void ) {
	itsIp	= NULL;
	itsPort	= 0;
	itsPass	= NULL;
}

// --------------------------------------------------------------------
// EOF:	CFurserController.cpp
// --------------------------------------------------------------------
