// --------------------------------------------------------------------
// CFurserDoc.cpp
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserDoc.h"

// --------------------------------------------------------------------
CFurserDoc::CFurserDoc	() {
	CFurserDoc::Cleanup();
}

// --------------------------------------------------------------------
CFurserDoc::~CFurserDoc	() {
	CFurserDoc::Free();
}

// --------------------------------------------------------------------
CFurserString_l	CFurserDoc::ControllerNames	( void ) const {
	CFurserString_l			list;
	CFurserController_lci	loop;
    for	(	loop  = itsControllerList.begin();
			loop != itsControllerList.end();
            loop++ ) {
    	list.push_back( (*loop).Ip() );
    }
	return	list;
}

// --------------------------------------------------------------------
const CFurserController_l &	CFurserDoc::ControllerList	( void ) const {
	return	itsControllerList;
}

// --------------------------------------------------------------------
CFurserController	CFurserDoc::GetController	( const char * aIp ) const {
	CFurserController_lci	loop;
    for	(	loop  = itsControllerList.begin();
			loop != itsControllerList.end();
            loop++ ) {
    	if	( *loop == aIp ) return *loop;
    }
    CFurserController dummy;
    return dummy;
}

// --------------------------------------------------------------------
bool	CFurserDoc::HasController	( const char * aIp ) const {
	CFurserController_lci	loop;
    for	(	loop  = itsControllerList.begin();
			loop != itsControllerList.end();
            loop++ ) {
    	if	( *loop == aIp ) return true;
    }
	return false;
}

// --------------------------------------------------------------------
void	CFurserDoc::SetController	( const char * aIp, const CFurserController & aC ) {
	if	( ( ! CFurserDoc::HasController( aC.Ip() ) ) || ( aC == aIp ) ) {
		CFurserController_li	loop;
    	for	(	loop  = itsControllerList.begin();
				loop != itsControllerList.end();
            	loop++ ) {
	    	if	( *loop == aIp ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserDoc::AddController	( const CFurserController & aC ) {
	if	( ! CFurserDoc::HasController( aC.Ip() ) ) {
    	itsControllerList.push_back( aC );
	}
}

// --------------------------------------------------------------------
void	CFurserDoc::DelController	( const CFurserController & aC ) {
	itsControllerList.remove( aC );
}

// --------------------------------------------------------------------
void	CFurserDoc::Save	( const char * aFile ) const {
	CFurserController_lci	loop;
	dword_t					ix;
	CWinIniFile				inifile;
    CWinIniSection			section;

	section.Name( "Furser" );
	section.Insert( "ControllerCount", (int)itsControllerList.size() );
	inifile.Insert( section );

    ix = 0;
    for	(	loop  = itsControllerList.begin();
			loop != itsControllerList.end();
            loop++ ) {
    	(*loop).Save( inifile, ix++ );
    }

	::unlink( aFile );
	inifile.Write( aFile );
}

// --------------------------------------------------------------------
void	CFurserDoc::Load	( const char * aFile ) {
	struct stat	mystat;
    if	( ! ::stat( aFile, &mystat ) ) {
		CWinIniFile	inifile;
        dword_t		count, ix;

        inifile.Read( aFile );

		// Get all controllers
        count = inifile.IntValue( "Furser", "ControllerCount" );
		itsControllerList.clear();
        for	( ix = 0; ix < count; ix++ ) {
            CFurserController	myCtl;
            myCtl.Load( inifile, ix );
            CFurserDoc::AddController( myCtl );
        }
    }
}

// --------------------------------------------------------------------
void	CFurserDoc::Free	( void ) {
	CFurserDoc::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserDoc::Cleanup	( void ) {
	itsControllerList.clear();
}

// --------------------------------------------------------------------
// EOF:	CFurserDoc.cpp
// --------------------------------------------------------------------
