// --------------------------------------------------------------------
// CFurserWizard.cpp
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserWizard.h"

// --------------------------------------------------------------------
CFurserWizard::CFurserWizard	() {
    itsQeryList.clear();
}

// --------------------------------------------------------------------
CFurserWizard::~CFurserWizard	() {
    itsQeryList.clear();
}

// --------------------------------------------------------------------
void	CFurserWizard::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	CWinIniItem_l	itemlist;
    CWinIniItem_li	itemloop;

	// Load up the query list
    itsQeryList.clear();
	itemlist = aIni.ItemList( aSecName, "Query" );
    for	( itemloop = itemlist.begin(); itemloop != itemlist.end(); itemloop++ ) {
        CFurserWizQery	qery;
        qery.Load( aIni, (*itemloop).Value() );
        itsQeryList.push_back( qery );
    }
}

// --------------------------------------------------------------------
const CFurserWizQery_l &	CFurserWizard::QeryList	( void ) const {
	return	itsQeryList;
}

// --------------------------------------------------------------------
CFurserWizQery &			CFurserWizard::Qery	( int aIx ) {
	CFurserWizQery_li	loop;
    for	( loop = itsQeryList.begin(); loop != itsQeryList.end(); loop++ ) {
		if	( aIx <= 0 )	return *loop;
        aIx--;
    }
	return itsFallback;
}

// --------------------------------------------------------------------
// EOF:	CFurserWizard.cpp
// --------------------------------------------------------------------
