// --------------------------------------------------------------------
// CFurserWizardList.cpp
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	<vcl.h>
#include 	<dir.h>
#include	"CFurserWizardList.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserWizardList::CFurserWizardList () {
	itsCaptionList.clear();
	itsDescList.clear();
	itsFileList.clear();
}

// --------------------------------------------------------------------
CFurserWizardList::~CFurserWizardList() {
	itsCaptionList.clear();
	itsDescList.clear();
	itsFileList.clear();
}

// --------------------------------------------------------------------
void	CFurserWizardList::Load		( const char * aApp, const char * aWizDir ) {
	TSearchRec	sr;
	char		wizpath	[512];
    char		wizfile	[512];
	char		wizwild	[512];

    // Path for this set of wizard files
    ::fnsplit( aApp, wizpath, NULL, NULL, NULL );
    ::fnsplit( aApp, NULL, wizpath + ::strlen( wizpath ), NULL, NULL );
    ::strcat( wizpath, "Wizards\\" );
    ::strcat( wizpath, aWizDir );
    ::strcat( wizpath, "\\" );

	// Wildcard for the files
    ::strcpy( wizwild, wizpath );
    ::strcat( wizwild, "*.ini" );

    if	( FindFirst( wizwild, faAnyFile, sr ) == 0 ) {
    	try {
			do {
				if	( sr.Name == "." )	continue;
				::strcpy( wizfile, wizpath );
            	::strcat( wizfile, sr.Name.c_str() );
                CFurserWizardList::ProcessFile( wizfile );
			}	while ( FindNext( sr ) == 0 );
			FindClose( sr );
        }
        catch	( ... ) {
        	FindClose( sr );
            throw;
        }
    }
	else {
    	throw	CError( "No suitable files found" );
    }
}

// --------------------------------------------------------------------
const CFurserString_l &	CFurserWizardList::CaptionList	( void ) const {
	return	itsCaptionList;
}

// --------------------------------------------------------------------
const char *	CFurserWizardList::Description	( int aIx )	 const {
	CFurserString_lci	loop = itsDescList.begin();
    while	( ( aIx > 0 ) && ( loop != itsDescList.end() ) ) {
    	aIx--;
        loop++;
    }
    return  loop != itsDescList.end() ? (*loop).c_str() : "";
}

// --------------------------------------------------------------------
const char *	CFurserWizardList::WizardFile	( int aIx )  const {
	CFurserString_lci	loop = itsFileList.begin();
    while	( ( aIx > 0 ) && ( loop != itsFileList.end() ) ) {
    	aIx--;
        loop++;
    }
    return  loop != itsFileList.end() ? (*loop).c_str() : "";
}

// --------------------------------------------------------------------
void			CFurserWizardList::ProcessFile	( const char * aFile ) {
	char *		caption		= NULL;
    char *		description	= NULL;
	FILE *		mystrm 		= NULL;
    char		linebuf[1024];
    struct stat	mystat;

	try	{
        if	( ::stat( aFile, &mystat ) ) {
        	throw	CError( ::strerror( errno ) );
        }
        mystrm = ::fopen( aFile, "rt" );
        if	( ! mystrm ) {
        	throw	CError( ::strerror( errno ) );
        }

		// The first line should be the caption
        if	( ! ::fgets( linebuf, sizeof( linebuf ) - 1, mystrm ) ) {
        	throw	CError( ::strerror( errno ) );
        }
        ::my_strtail( linebuf );
        if	( ::strncmp( linebuf, ";# ", 3 ) ) {
        	throw CError( "Malformatted wizard file" );
        }
		caption = ::my_private_strdup( linebuf + 3 );

        // Next lines are the description
        if	( ! ::fgets( linebuf, sizeof( linebuf ) - 1, mystrm ) ) {
        	throw	CError( ::strerror( errno ) );
        }
        ::my_strtail( linebuf );
		while	( ::strncmp( linebuf, ";$ ", 3 ) == 0 ) {
            if	( description ) {
            	char *	tstr = new char [ ::strlen( description ) + ::strlen( linebuf ) + 5 ];
                ::strcpy( tstr, description );
                ::strcat( tstr, "\n" );
                ::strcat( tstr, linebuf + 3 );
                delete [] description;
                description = tstr;
            }
            else {
				description = ::my_private_strdup( linebuf + 3 );
            }
	        if	( ! ::fgets( linebuf, sizeof( linebuf ) - 1, mystrm ) ) {
    	    	throw	CError( ::strerror( errno ) );
        	}
	        ::my_strtail( linebuf );
        }

        // Fill in the lists
        itsCaptionList.push_back( caption );
        itsDescList.push_back( description );
        itsFileList.push_back( aFile );
        delete [] description;
        delete [] caption;
		::fclose( mystrm );
    }
    catch	( ... ) {
        if	( caption )		delete [] description;
        if	( description )	delete [] caption;
		if	( mystrm )	::fclose( mystrm );
		throw;
    }
}

// --------------------------------------------------------------------
// EOF:	CFurserWizardList.cpp
// --------------------------------------------------------------------
