//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TGroupEditDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TGroupEditDialog *GroupEditDialog = NULL;
//---------------------------------------------------------------------------
__fastcall TGroupEditDialog::TGroupEditDialog(TComponent* Owner) : TForm(Owner) {
	GroupData = NULL;
    itsUpdateFlag = 1;
	PageControl->ActivePage = PageControl->Pages[0];
	PageControl->ActivePage = PageControl->Pages[1];
	PageControl->ActivePage = PageControl->Pages[0];
    itsUpdateFlag = 0;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::Populate( void ) {
	itsUpdateFlag++;

    if	( GroupNameEdit->Text != GroupData->GroupName() ) {
	    GroupNameEdit->Text = GroupData->GroupName();
    }
	AnsiString	numbs = GroupData->GameSecLevel();
    if	( SecLevelEdit->Text != numbs ) {
    	SecLevelEdit->Text = numbs;
    }
    if	( CommentEdit->Text != GroupData->Comment() ) {
    	CommentEdit->Text = GroupData->Comment();
    }

    if		( PageControl->ActivePage == PageControl->Pages[0] ) {
		TGroupEditDialog::PopulateAdmin();
    }
    else if	( PageControl->ActivePage == PageControl->Pages[1] ) {
		TGroupEditDialog::PopulateGroup();
    }
    else if	( PageControl->ActivePage == PageControl->Pages[2] ) {
		TGroupEditDialog::PopulateGame();
    }
    else if	( PageControl->ActivePage == PageControl->Pages[3] ) {
		TGroupEditDialog::PopulateKick();
    }
    else if	( PageControl->ActivePage == PageControl->Pages[4] ) {
		TGroupEditDialog::PopulateExtra();
    }

    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PopulateAdmin( void ) {
    itsUpdateFlag++;
    AdminAllCheckBox->Checked = GroupData->HasPrivilege( "A" );
    AdminAlCheckBox->Checked  = GroupData->HasPrivilege( "Al" );
    AdminAaCheckBox->Checked  = GroupData->HasPrivilege( "Aa" );
    AdminAeCheckBox->Checked  = GroupData->HasPrivilege( "Ae" );
    AdminAgCheckBox->Checked  = GroupData->HasPrivilege( "Ag" );
    AdminAmCheckBox->Checked  = GroupData->HasPrivilege( "Am" );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PopulateGroup( void ) {
    itsUpdateFlag++;
    GroupAllCheckBox->Checked = GroupData->HasPrivilege( "G" );
    GroupGlCheckBox->Checked  = GroupData->HasPrivilege( "Gl" );
    GroupGaCheckBox->Checked  = GroupData->HasPrivilege( "Ga" );
    GroupGeCheckBox->Checked  = GroupData->HasPrivilege( "Ge" );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PopulateGame( void ) {
    itsUpdateFlag++;
    GameAllCheckBox->Checked = GroupData->HasPrivilege( "M" );
    GameMrCheckBox->Checked	 = GroupData->HasPrivilege( "Mr" );
    GameMtCheckBox->Checked	 = GroupData->HasPrivilege( "Mt" );
    GameMmCheckBox->Checked	 = GroupData->HasPrivilege( "Mm" );
    GameMlCheckBox->Checked	 = GroupData->HasPrivilege( "Ml" );
    GameMsCheckBox->Checked  = GroupData->HasPrivilege( "Ms" );
    GameMuCheckBox->Checked  = GroupData->HasPrivilege( "Mu" );
    GameMbCheckBox->Checked  = GroupData->HasPrivilege( "Mb" );
    GameMaCheckBox->Checked  = GroupData->HasPrivilege( "Ma" );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PopulateKick( void ) {
    itsUpdateFlag++;
    KickAllCheckBox->Checked = GroupData->HasPrivilege( "K" );
    KickKpCheckBox->Checked	 = GroupData->HasPrivilege( "Kp" );
    KickKbCheckBox->Checked  = GroupData->HasPrivilege( "Kb" );
    KickKoCheckBox->Checked  = GroupData->HasPrivilege( "Ko" );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PopulateExtra( void ) {
    itsUpdateFlag++;
    ExtraAllCheckBox->Checked = GroupData->HasPrivilege( "X" );
    ExtraXbCheckBox->Checked  = GroupData->HasPrivilege( "Xb" );
    ExtraXcCheckBox->Checked  = GroupData->HasPrivilege( "Xc" );
    ExtraXpCheckBox->Checked  = GroupData->HasPrivilege( "Xp" );
    ExtraXsCheckBox->Checked  = GroupData->HasPrivilege( "Xs" );
    ExtraXiCheckBox->Checked  = GroupData->HasPrivilege( "Xi" );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::PageControlChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    TGroupEditDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GroupNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    GroupData->GroupName( GroupNameEdit->Text.c_str() );
    TGroupEditDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::SecLevelEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    GroupData->GameSecLevel( ::atoi( SecLevelEdit->Text.c_str() ) );
    TGroupEditDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::CommentEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    GroupData->Comment( CommentEdit->Text.c_str() );
    TGroupEditDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAllCheckBoxClick(TObject *Sender){
	if	( itsUpdateFlag )	return;
    if	( AdminAllCheckBox->Checked ) {
    	GroupData->AddPrivilege( "A" );
    }
    else {
    	GroupData->DelPrivilege( "A" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAlCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( AdminAlCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Al" );
    }
    else {
    	GroupData->DelPrivilege( "Al" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAaCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( AdminAaCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Aa" );
    }
    else {
    	GroupData->DelPrivilege( "Aa" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAeCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( AdminAeCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ae" );
    }
    else {
    	GroupData->DelPrivilege( "Ae" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAgCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( AdminAgCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ag" );
    }
    else {
    	GroupData->DelPrivilege( "Ag" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::AdminAmCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( AdminAmCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Am" );
    }
    else {
    	GroupData->DelPrivilege( "Am" );
    }
    TGroupEditDialog::PopulateAdmin();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GroupAllCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GroupAllCheckBox->Checked ) {
    	GroupData->AddPrivilege( "G" );
    }
    else {
    	GroupData->DelPrivilege( "G" );
    }
    TGroupEditDialog::PopulateGroup();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GroupGlCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GroupGlCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Gl" );
    }
    else {
    	GroupData->DelPrivilege( "Gl" );
    }
    TGroupEditDialog::PopulateGroup();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GroupGaCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GroupGaCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ga" );
    }
    else {
    	GroupData->DelPrivilege( "Ga" );
    }
    TGroupEditDialog::PopulateGroup();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GroupGeCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GroupGeCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ge" );
    }
    else {
    	GroupData->DelPrivilege( "Ge" );
    }
    TGroupEditDialog::PopulateGroup();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameAllCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameAllCheckBox->Checked ) {
    	GroupData->AddPrivilege( "M" );
    }
    else {
    	GroupData->DelPrivilege( "M" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMrCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMrCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Mr" );
    }
    else {
    	GroupData->DelPrivilege( "Mr" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMtCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMtCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Mt" );
    }
    else {
    	GroupData->DelPrivilege( "Mt" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMmCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMmCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Mm" );
    }
    else {
    	GroupData->DelPrivilege( "Mm" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMlCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMlCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ml" );
    }
    else {
    	GroupData->DelPrivilege( "Ml" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMsCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMsCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ms" );
    }
    else {
    	GroupData->DelPrivilege( "Ms" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMuCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMuCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Mu" );
    }
    else {
    	GroupData->DelPrivilege( "Mu" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMbCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMbCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Mb" );
    }
    else {
    	GroupData->DelPrivilege( "Mb" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::GameMaCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( GameMaCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ma" );
    }
    else {
    	GroupData->DelPrivilege( "Ma" );
    }
    TGroupEditDialog::PopulateGame();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::KickAllCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( KickAllCheckBox->Checked ) {
    	GroupData->AddPrivilege( "K" );
    }
    else {
    	GroupData->DelPrivilege( "K" );
    }
    TGroupEditDialog::PopulateKick();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::KickKpCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( KickKpCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Kp" );
    }
    else {
    	GroupData->DelPrivilege( "Kp" );
    }
    TGroupEditDialog::PopulateKick();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::KickKbCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( KickKbCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Kb" );
    }
    else {
    	GroupData->DelPrivilege( "Kb" );
    }
    TGroupEditDialog::PopulateKick();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::KickKoCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( KickKoCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Ko" );
    }
    else {
    	GroupData->DelPrivilege( "Ko" );
    }
    TGroupEditDialog::PopulateKick();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraAllCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraAllCheckBox->Checked ) {
    	GroupData->AddPrivilege( "X" );
    }
    else {
    	GroupData->DelPrivilege( "X" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraXbCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraXbCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Xb" );
    }
    else {
    	GroupData->DelPrivilege( "Xb" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraXcCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraXcCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Xc" );
    }
    else {
    	GroupData->DelPrivilege( "Xc" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraXpCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraXpCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Xp" );
    }
    else {
    	GroupData->DelPrivilege( "Xp" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraXsCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraXsCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Xs" );
    }
    else {
    	GroupData->DelPrivilege( "Xs" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::ExtraXiCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ExtraXiCheckBox->Checked ) {
    	GroupData->AddPrivilege( "Xi" );
    }
    else {
    	GroupData->DelPrivilege( "Xi" );
    }
    TGroupEditDialog::PopulateExtra();
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::OkButtonClick(TObject *Sender) {
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TGroupEditDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
