//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainDialog *MainDialog;

//---------------------------------------------------------------------------
// Main initialization of the form - also reads in the initial setup
//---------------------------------------------------------------------------
__fastcall TMainDialog::TMainDialog(TComponent* Owner) : TForm(Owner) {

	// Looks cumbersome but this is needed to force the page
	itsUpdateFlag = 1;	// No ordinary updates during the initialization
	ServerPageControl->ActivePage = ServerPageControl->Pages[0];
	ServerPageControl->ActivePage = ServerPageControl->Pages[1];
	ServerPageControl->ActivePage = ServerPageControl->Pages[0];
	itsUpdateFlag = 0;	// Ordinary updates allowed now

	// Set config file name
	::fnsplit( Application->ExeName.c_str(), itsConfigFile, NULL, NULL, NULL );
	::fnsplit( Application->ExeName.c_str(), NULL, itsConfigFile + ::strlen( itsConfigFile ), NULL, NULL );
	::fnsplit( Application->ExeName.c_str(), NULL, NULL, itsConfigFile + ::strlen( itsConfigFile ), NULL );
	::strcat( itsConfigFile, ".ini" );

	// Load document
    itsDoc.Load( itsConfigFile );

    // Clear the client
    itsClient	= NULL;
    itsSrData	= NULL;

    // Populate everything
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FormClose(TObject *Sender,TCloseAction &Action) {
	if	( ServerSaveBitBtn->Enabled ) {
    	if	( Application->MessageBox(	"Do you want to loose the changes ?",
        								"Changes not saved to the server",
                                        MB_YESNO | MB_DEFBUTTON2 | MB_ICONWARNING ) ==  IDNO ) {
        	Action = caNone;
            return;
        }
    }
    if	( itsSrData )	delete itsSrData;
    if	( itsClient )	delete itsClient;
    itsSrData = NULL;
    itsClient = NULL;
}

//---------------------------------------------------------------------------

