//---------------------------------------------------------------------------
// TMainDialogServerPaneGames.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TSettingsDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneGames( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
    	TMainDialog::SetControlEnable( GamesAddBitBtn, false );
        TMainDialog::SetControlEnable( GamesDelBitBtn, false );
        TMainDialog::SetControlEnable( GamesListView, false );
        TMainDialog::SetControlEnable( GamesNameEdit, false );
        TMainDialog::SetControlEnable( GamesMapListEdit, false );
        TMainDialog::SetControlEnable( GamesPrefixEdit, false );
        TMainDialog::SetControlEnable( GamesDescEdit, false );
        TMainDialog::SetControlEnable( GamesSetnNewBitBtn, false );
        TMainDialog::SetControlEnable( GamesSetnEditBitBtn, false );
        TMainDialog::SetControlEnable( GamesSetnDelBitBtn, false );
        TMainDialog::SetControlEnable( GamesSettingsListView, false );
    }
    else if	( itsSrData ) {
   		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

    	TMainDialog::SetControlEnable( GamesAddBitBtn, true );
        TMainDialog::SetControlEnable( GamesListView, true );
        TMainDialog::PopulateGamesListView( GamesListView, srvr.GameList() );

        bool editable = (GamesListView->Selected != NULL);

        TMainDialog::SetControlEnable( GamesDelBitBtn, editable );
        TMainDialog::SetControlEnable( GamesNameEdit, editable );
        TMainDialog::SetControlEnable( GamesMapListEdit, editable );
        TMainDialog::SetControlEnable( GamesPrefixEdit, editable );
        TMainDialog::SetControlEnable( GamesDescEdit, editable );
        TMainDialog::SetControlEnable( GamesSetnNewBitBtn, editable );
        TMainDialog::SetControlEnable( GamesSettingsListView, editable );
        if	( editable ) {
			CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
			if	( GamesNameEdit->Text != game.GameName() ) {
            	GamesNameEdit->Text = game.GameName();
            }
			if	( GamesMapListEdit->Text != game.MapList() ) {
            	GamesMapListEdit->Text = game.MapList();
            }
            if	( GamesPrefixEdit->Text != game.MapPrefix() ) {
            	GamesPrefixEdit->Text = game.MapPrefix();
            }
            if	( GamesDescEdit->Text != game.Description() ) {
            	GamesDescEdit->Text = game.Description();
            }
			TMainDialog::PopulateSettingsView( GamesSettingsListView, game.SettingList() );

			editable = (GamesSettingsListView->Selected != NULL);
	        TMainDialog::SetControlEnable( GamesSetnEditBitBtn, editable );
    	    TMainDialog::SetControlEnable( GamesSetnDelBitBtn, editable );
        }
        else {
	        TMainDialog::SetControlEnable( GamesSetnEditBitBtn, false );
    	    TMainDialog::SetControlEnable( GamesSetnDelBitBtn, false );
        }
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesSettingsListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    game.GameName( GamesNameEdit->Text.c_str() );
    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesMapListEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    game.MapList( GamesMapListEdit->Text.c_str() );
    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesPrefixEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    game.MapPrefix( GamesPrefixEdit->Text.c_str() );
    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesDescEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    game.Description( GamesDescEdit->Text.c_str() );
    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game;
    game.GameName( "Another Game" );
    srvr.AddGame( game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
	TMainDialog::SetListViewFocus( GamesListView, game.GameName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    srvr.DelGame( game );
    itsSrData->SetServer(  TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesSetnNewBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn;
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
    setn.SettingName( "Change this name" );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		game.AddSetting( setn );
	    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneGames();
	TMainDialog::SetListViewFocus( GamesSettingsListView, setn.SettingName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesSetnEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	if	( ! GamesSettingsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn = game.GetSetting( GamesSettingsListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		game.SetSetting( GamesSettingsListView->Selected->Caption.c_str(), setn );
	    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesSetnDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! GamesListView->Selected )			return;
	if	( ! GamesSettingsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
   	CFurserSrGame	game = srvr.GetGame( GamesListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn = game.GetSetting( GamesSettingsListView->Selected->Caption.c_str() );
	game.DelSetting( setn );
    srvr.SetGame( GamesListView->Selected->Caption.c_str(), game );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GamesListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneGames();
}

//---------------------------------------------------------------------------
