//---------------------------------------------------------------------------
// TMainDialogServerPaneMaps.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneMaps( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
		TMainDialog::SetControlEnable( MapsAddBitBtn, false );
        TMainDialog::SetControlEnable( MapsDeleteBitBtn, false );
        TMainDialog::SetControlEnable( MapsEarlierBitBtn, false );
        TMainDialog::SetControlEnable( MapsLaterBitBtn, false );
        TMainDialog::SetControlEnable( MapsShowRotCheckBox, false );
        TMainDialog::SetControlEnable( MapsListView, false );
        TMainDialog::SetControlEnable( MapsNameEdit, false );
        TMainDialog::SetControlEnable( MapsArgsEdit, false );
        TMainDialog::SetControlEnable( MapsRotateCheckBox, false );
        MapRotateInfoPanel->Caption = "";
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

		TMainDialog::SetControlEnable( MapsAddBitBtn, true );
        TMainDialog::SetControlEnable( MapsShowRotCheckBox, true );
        TMainDialog::SetControlEnable( MapsListView, true );
        TMainDialog::PopulateMapsListView( MapsListView, srvr.MapList(), MapsShowRotCheckBox->Checked );

		char	infobuf	[128];
        int		count = srvr.RotateCount();
        if		( count < 1 ) {
			::strcpy( infobuf, "No maps selected" );
        }
        else if	( count == 1 ) {
			::strcpy( infobuf, "One map selected" );
        }
        else {
        	::sprintf( infobuf, "%i maps rotating", count );
        }
        MapRotateInfoPanel->Caption = infobuf;

        bool	editable = (MapsListView->Selected != NULL);
        TMainDialog::SetControlEnable( MapsDeleteBitBtn, editable );
        TMainDialog::SetControlEnable( MapsNameEdit, editable );
        TMainDialog::SetControlEnable( MapsArgsEdit, editable );
        TMainDialog::SetControlEnable( MapsRotateCheckBox, editable );
		if	( editable ) {
			CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
			if	( MapsNameEdit->Text != levl.MapName() ) {
            	MapsNameEdit->Text = levl.MapName();
            }
			if	( MapsArgsEdit->Text != levl.GameClass() ) {
            	MapsArgsEdit->Text = levl.GameClass();
            }
            MapsRotateCheckBox->Checked = levl.Rotate();
            if	( srvr.MapList().size() > 1 ) {
		        TMainDialog::SetControlEnable( MapsEarlierBitBtn, !srvr.FirstMap( levl ) && levl.Rotate() );
    		    TMainDialog::SetControlEnable( MapsLaterBitBtn, !srvr.LastMap( levl ) && levl.Rotate() );
            }
            else {
		        TMainDialog::SetControlEnable( MapsEarlierBitBtn, false );
    		    TMainDialog::SetControlEnable( MapsLaterBitBtn, false );
            }
        }
        else {
	        TMainDialog::SetControlEnable( MapsEarlierBitBtn, false );
    	    TMainDialog::SetControlEnable( MapsLaterBitBtn, false );
        }
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsShowRotCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    levl.MapName( MapsNameEdit->Text.c_str() );
    srvr.SetMap( MapsListView->Selected->Caption.c_str(), levl );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsArgsEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    levl.GameClass( MapsArgsEdit->Text.c_str() );
    srvr.SetMap( MapsListView->Selected->Caption.c_str(), levl );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsRotateCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    levl.Rotate( MapsRotateCheckBox->Checked );
    srvr.SetMap( MapsListView->Selected->Caption.c_str(), levl );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsListViewDblClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
    MapsRotateCheckBox->Checked = !MapsRotateCheckBox->Checked;
    TMainDialog::MapsRotateCheckBoxClick( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl;
    levl.MapName( "DM-AnotherMap" );
    srvr.AddMap( levl );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMaps();
	TMainDialog::SetListViewFocus( MapsListView, levl.MapName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    srvr.DelMap( levl );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsEarlierBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    srvr.Earlier( levl, MapsShowRotCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );

	itsUpdateFlag++;
    TMainDialog::PopulateMapsListView( MapsListView, srvr.MapList(), MapsShowRotCheckBox->Checked );
	for	( int ix = 0; ix < MapsListView->Items->Count; ix++ ) {
    	if	( MapsListView->Items->Item[ix]->Caption == levl.MapName() ) {
			MapsListView->Selected = MapsListView->Items->Item[ix];
            break;
        }
    }
	itsUpdateFlag--;
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsLaterBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MapsListView->Selected )			return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrLevl	levl = srvr.GetMap( MapsListView->Selected->Caption.c_str() );
    srvr.Later( levl, MapsShowRotCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );

	itsUpdateFlag++;
    TMainDialog::PopulateMapsListView( MapsListView, srvr.MapList(), MapsShowRotCheckBox->Checked );
	for	( int ix = 0; ix < MapsListView->Items->Count; ix++ ) {
    	if	( MapsListView->Items->Item[ix]->Caption == levl.MapName() ) {
			MapsListView->Selected = MapsListView->Items->Item[ix];
            break;
        }
    }
	itsUpdateFlag--;
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MapsListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMaps();
}

//---------------------------------------------------------------------------

