//---------------------------------------------------------------------------
// TMainDialogServerPaneSchedule.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneSchedule( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
		TMainDialog::SetControlEnable( ScheduleNewBitBtn, false );
		TMainDialog::SetControlEnable( ScheduleDeleteBitBtn, false );
		TMainDialog::SetControlEnable( ScheduleListView, false );
		TMainDialog::SetControlEnable( ScheduleTypeComboBox, false, false );
		TMainDialog::SetControlEnable( ScheduleEnableCheckBox, false );
		TMainDialog::SetControlEnable( ScheduleStartDateDateTimePicker, false );
		TMainDialog::SetControlEnable( ScheduleStartTimeDateTimePicker, false );
		TMainDialog::SetControlEnable( ScheduleStartJobComboBox, false, false );
		TMainDialog::SetControlEnable( ScheduleEndDateDateTimePicker, false );
		TMainDialog::SetControlEnable( ScheduleEndTimeDateTimePicker, false );
		TMainDialog::SetControlEnable( ScheduleStopJobComboBox, false, false );
		TMainDialog::SetControlEnable( ScheduleStartBitBtn, false );
		TMainDialog::SetControlEnable( ScheduleStopBitBtn, false );
		TMainDialog::SetControlEnable( ScheduleRestartBitBtn, false );
        GameStatusPanel->Caption = "";
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

		TMainDialog::SetControlEnable( ScheduleNewBitBtn, ! srvr.Running() );
		TMainDialog::SetControlEnable( ScheduleListView, ! srvr.Running(), false );
        TMainDialog::PopulateScheduleView( ScheduleListView, srvr.EventList() );
		TMainDialog::SetControlEnable(	ScheduleStartBitBtn,
        								!srvr.GameRunning() &&
                                        srvr.Running() &&
                                        (srvr.RotateCount() > 0) );
		TMainDialog::SetControlEnable(	ScheduleStopBitBtn,
        								srvr.GameRunning() &&
                                        srvr.Running() );
		TMainDialog::SetControlEnable(	ScheduleRestartBitBtn,
        								srvr.GameRunning() &&
                                        srvr.Running() &&
                                        (srvr.RotateCount() > 0) );
        GameStatusPanel->Caption	= srvr.GameRunning()
        							? "Game Running"
                                    : srvr.Running() ? "Game Stopped" : "";

        bool editable = (! srvr.Running()) && ( ScheduleListView->Selected );

		TMainDialog::SetControlEnable( ScheduleDeleteBitBtn, editable );
		TMainDialog::SetControlEnable( ScheduleTypeComboBox, editable, false );
		TMainDialog::SetControlEnable( ScheduleEnableCheckBox, editable, false );
		TMainDialog::SetControlEnable( ScheduleStartJobComboBox, editable, false );
		TMainDialog::SetControlEnable( ScheduleStopJobComboBox, editable, false );
		TMainDialog::SetControlEnable( ScheduleStartTimeDateTimePicker, editable, false );
		TMainDialog::SetControlEnable( ScheduleEndTimeDateTimePicker, editable, false );

		if	( ScheduleListView->Selected ) {
			CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
        	ScheduleTypeComboBox->ItemIndex = evnt.EventType();
            ScheduleEnableCheckBox->Checked = evnt.Enabled();
            ScheduleStartJobComboBox->ItemIndex = evnt.StartTask();
            ScheduleStopJobComboBox->ItemIndex = evnt.EndTask();
			TMainDialog::SetPickerTime( ScheduleStartDateDateTimePicker, ScheduleStartTimeDateTimePicker, evnt.StartTime() );
			TMainDialog::SetPickerTime( ScheduleEndDateDateTimePicker, ScheduleEndTimeDateTimePicker, evnt.EndTime() );
        }
        else {
        	ScheduleTypeComboBox->ItemIndex = -1;
            ScheduleEnableCheckBox->Checked = false;
            ScheduleStartJobComboBox->ItemIndex = -1;
            ScheduleStopJobComboBox->ItemIndex = -1;

			TMainDialog::SetPickerTime( ScheduleStartDateDateTimePicker, ScheduleStartTimeDateTimePicker, ::time( NULL ) );
			TMainDialog::SetPickerTime( ScheduleEndDateDateTimePicker, ScheduleEndTimeDateTimePicker, ::time( NULL ) );
        }

        switch	( ScheduleTypeComboBox->ItemIndex ) {
            case	EVENT_TYPE_HOURLY:	// Hourly
            case	EVENT_TYPE_DAILY:	// Daily
			editable = false;
            break;
        }

		TMainDialog::SetControlEnable( ScheduleStartDateDateTimePicker, editable, false );
		TMainDialog::SetControlEnable( ScheduleEndDateDateTimePicker, editable, false );

        editable = ( ScheduleTypeComboBox->ItemIndex == EVENT_TYPE_ONCE );
		TMainDialog::SetControlEnable( ScheduleEndDateDateTimePicker, editable, false );
		TMainDialog::SetControlEnable( ScheduleEndTimeDateTimePicker, editable, false );
		TMainDialog::SetControlEnable( ScheduleStopJobComboBox, editable, false );

    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleTypeComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
	evnt.EventType( ScheduleTypeComboBox->ItemIndex );
	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleEnableCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
	evnt.Enabled( ScheduleEnableCheckBox->Checked );
	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleListViewDblClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
    ScheduleEnableCheckBox->Checked = !ScheduleEnableCheckBox->Checked;
    TMainDialog::ScheduleEnableCheckBoxClick( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStartDateDateTimePickerChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );

	evnt.StartTime( TMainDialog::GetPickerTime( ScheduleStartDateDateTimePicker, ScheduleStartTimeDateTimePicker ) );

	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStartTimeDateTimePickerChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );

	evnt.StartTime( TMainDialog::GetPickerTime( ScheduleStartDateDateTimePicker, ScheduleStartTimeDateTimePicker ) );

	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStartJobComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
	evnt.StartTask( ScheduleStartJobComboBox->ItemIndex );
	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleEndDateDateTimePickerChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );

	evnt.EndTime( TMainDialog::GetPickerTime( ScheduleEndDateDateTimePicker, ScheduleEndTimeDateTimePicker ) );

	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleEndTimeDateTimePickerChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );

	evnt.EndTime( TMainDialog::GetPickerTime( ScheduleEndDateDateTimePicker, ScheduleEndTimeDateTimePicker ) );

	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStopJobComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
	evnt.EndTask( ScheduleStopJobComboBox->ItemIndex );
	srvr.SetEvent( ScheduleListView->Selected->Caption.c_str(), evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleNewBitBtnClick(TObject *Sender) {
	int						id;
    char					ids[16];
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt;

    for	( id = 0; id < 100; id++ ) {
		::sprintf( ids, "#%02d", id );
        if	( ! srvr.HasEvent( ids ) ) {
			::sprintf( ids, "-%02d", id );
	        if	( ! srvr.HasEvent( ids ) ) {
				break;
            }
        }
    }

	if	( id >= 100 ) {
    	Application->MessageBox(	"Too many schedule entries",
        							"Unable to create a schedule entry",
                                    MB_OK | MB_ICONWARNING );
    }
    else {
		evnt.EventName( ids );
        evnt.StartTime( ::time(NULL) );
        evnt.EndTime( ::time(NULL) );
		srvr.AddEvent( evnt );
        itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
	TMainDialog::PopulateServerPaneSchedule();
	TMainDialog::SetListViewFocus( ScheduleListView, evnt.EventName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! ScheduleListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrEvnt	evnt = srvr.GetEvent( ScheduleListView->Selected->Caption.c_str() );
    srvr.DelEvent( evnt );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStartBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	TMainDialog::SendServerCommand( '1' );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleStopBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	TMainDialog::SendServerCommand( '2' );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleRestartBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	TMainDialog::SendServerCommand( '3' );
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScheduleListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneSchedule();
}

//---------------------------------------------------------------------------
