//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TServerWizardDialog.h"
#include "TSelectWizardDialog.h"
#include "CError.hxx"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TServerWizardDialog *ServerWizardDialog = NULL;
//---------------------------------------------------------------------------
__fastcall TServerWizardDialog::TServerWizardDialog(TComponent* Owner) : TForm(Owner) {
	CWinIniFile			ini;
	CFurserWizQery_lci	qery;
    int					ix;
	itsUpdateFlag = 1;
	try {
   		Application->CreateForm( __classid(TSelectWizardDialog), &SelectWizardDialog );
	    SelectWizardDialog->Populate( "Servers" );
		if	( SelectWizardDialog->ShowModal() == mrOk ) {
			ini.Read( SelectWizardDialog->WizardFile.c_str() );
            ServerData.Load( ini, "Server" );
            itsWizard.Load( ini, "Wizard" );
			ix	 = 0;
			ParamListView->Items->Clear();
			for	(	qery  = itsWizard.QeryList().begin();
                    qery != itsWizard.QeryList().end();
                    qery++, ix++ ) {
        		ParamListView->Items->Add();
				ParamListView->Items->Item[ix]->Caption = (*qery).Caption();
	            ParamListView->Items->Item[ix]->SubItems->Add( (*qery).Value() );
            }
	   		Application->OnIdle = NULL;
	    }
		else {
			Application->OnIdle = MyIdleHandler;	// Delayed close
	    }
    	SelectWizardDialog->Release();
		SelectWizardDialog = NULL;
    }
    catch	( ... ) {
		if	( SelectWizardDialog ) {
    		SelectWizardDialog->Release();
			SelectWizardDialog = NULL;
        }
		Application->OnIdle = MyIdleHandler;	// Delayed close
    }
	itsUpdateFlag = 0;
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::MyIdleHandler(TObject *Sender, bool &Done ) {
	Done = false;
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
int	__fastcall	TServerWizardDialog::DetermineControlType( const CFurserWizQery & aQ ) {
	switch	( aQ.Type() ) {
		case	qerytype_string:
		case	qerytype_filename:	return	0;
   		case	qerytype_boolean:	return	1;
	}
    if	( aQ.Type() == qerytype_integer ) {
    	int	min	= ::atoi( aQ.Min() );
        int	max = ::atoi( aQ.Max() );
        if	( ( min < max ) && ( (max - min) < 256 ) )	return	2;
		return	0;
    }

    if	( aQ.Type() == qerytype_float ) {
    	double	min	= ::atof( aQ.Min() );
        double	max = ::atof( aQ.Max() );
        if	( ( min < max ) && ( (max - min) < 10.0 ) )	return	2;
	}
	return	0;
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::SetShowControl( int aC ) {
	ParamEdit->Enabled		= (aC == 0);
	ParamCheckBox->Enabled	= (aC == 1);
    ParamTrackBar->Enabled	= (aC == 2);
	ParamEdit->Visible		= (aC == 0);
	ParamCheckBox->Visible	= (aC == 1);
    ParamTrackBar->Visible	= (aC == 2);
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ShowParamValue( const CFurserWizQery & aQ ) {
	int	ct = TServerWizardDialog::DetermineControlType( aQ );
    TServerWizardDialog::SetShowControl( ct );
	switch	( ct ) {
		case	0:
        ParamEdit->Text = aQ.Value();
        break;

        case	1:
        ParamCheckBox->Checked = ::stricmp( aQ.Value(), "true" ) == 0;
        ParamCheckBox->Caption = aQ.Caption();
        break;

        case	2:
	    if	( aQ.Type() == qerytype_float ) {
			ParamTrackBar->Min		= (int)( ::atof( aQ.Min() )   * 100.0 );
			ParamTrackBar->Max		= (int)( ::atof( aQ.Max() )   * 100.0 );
			ParamTrackBar->Position	= (int)( ::atof( aQ.Value() ) * 100.0 );
        }
        else {
			ParamTrackBar->Min		= ::atoi( aQ.Min() );
			ParamTrackBar->Max		= ::atoi( aQ.Max() );
			ParamTrackBar->Position	= ::atoi( aQ.Value() );
        }
    }
	HelpMemo->Lines->Text = aQ.Help();
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ParamListViewSelectItem(TObject *Sender, TListItem *Item, bool Selected) {
	if	( itsUpdateFlag ) return;
   	itsUpdateFlag++;
    if	( ParamListView->Selected ) {
		TServerWizardDialog::ShowParamValue( itsWizard.Qery( ParamListView->Selected->Index ) );
    }
    else {
		TServerWizardDialog::SetShowControl( -1 );
		HelpMemo->Lines->Text = "";
    }
   	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ParamEditExit(TObject *Sender) {
	if	( itsUpdateFlag ) 				return;
    if	( ! ParamListView->Selected )	return;

    try	{
        itsWizard.Qery( ParamListView->Selected->Index ).Check( ParamEdit->Text.c_str() );
    }
    catch	( CError e ) {
    	Application->MessageBox(	(char *)e.Error(),
        				   			"Please, correct the value",
                                    MB_OK | MB_ICONWARNING );
    }
    catch	( ... ) {
    	Application->MessageBox(	"Unknown error",
        				   			"Please, correct the value",
                                    MB_OK | MB_ICONWARNING );
    }
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ParamEditChange(TObject *Sender) {
	if	( itsUpdateFlag ) 				return;
    if	( ! ParamListView->Selected )	return;
	itsWizard.Qery( ParamListView->Selected->Index ).Value( ParamEdit->Text.c_str() );
    ParamListView->Selected->SubItems->Strings[0] = ParamEdit->Text.c_str();
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ParamCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag ) 				return;
    if	( ! ParamListView->Selected )	return;
	itsWizard.Qery( ParamListView->Selected->Index ).Value( ParamCheckBox->Checked ? "True" : "False" );
	ParamListView->Selected->SubItems->Strings[0] = ParamCheckBox->Checked ? "True" : "False";
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::ParamTrackBarChange(TObject *Sender) {
	char	valbuf[32];
	if	( itsUpdateFlag ) 				return;
    if	( ! ParamListView->Selected )	return;
    if	( itsWizard.Qery( ParamListView->Selected->Index ).Type() == qerytype_float ) {
    	::sprintf( valbuf, "%.3lf", (double)ParamTrackBar->Position / (double)100.0 );
	}
    else {
    	::sprintf( valbuf, "%d", ParamTrackBar->Position );
    }
	itsWizard.Qery( ParamListView->Selected->Index ).Value( valbuf );
	ParamListView->Selected->SubItems->Strings[0] = valbuf;
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::OkButtonClick(TObject *Sender) {
	if	( itsUpdateFlag ) 				return;
	ServerData.MacroList( itsWizard.QeryList() );
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TServerWizardDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------

